/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.YamlParser;
import org.testng.xml.IFileParser;
import org.testng.xml.IPostProcessor;
import org.testng.xml.SuiteXmlParser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String TESTNG_DTD = "testng-1.0.dtd";
    public static final String DEPRECATED_TESTNG_DTD_URL = "http://beust.com/testng/testng-1.0.dtd";
    public static final String TESTNG_DTD_URL = "http://testng.org/testng-1.0.dtd";
    public static final String DEFAULT_FILENAME = "testng.xml";
    private static final IFileParser<XmlSuite> XML_PARSER = new SuiteXmlParser();
    private static final IFileParser<XmlSuite> YAML_PARSER = new YamlParser();
    private static final IFileParser<XmlSuite> DEFAULT_FILE_PARSER = XML_PARSER;
    private String m_fileName;
    private InputStream m_inputStream;
    private IPostProcessor m_postProcessor;
    private boolean m_loadClasses = true;

    public Parser(String fileName) {
        this.init(fileName, null, null);
    }

    public Parser() throws FileNotFoundException {
        this.init(null, null, null);
    }

    public Parser(InputStream is) {
        this.init(null, is, null);
    }

    private void init(String fileName, InputStream is, IFileParser fp) {
        this.m_fileName = fileName != null ? fileName : DEFAULT_FILENAME;
        this.m_inputStream = is;
    }

    public void setPostProcessor(IPostProcessor processor) {
        this.m_postProcessor = processor;
    }

    public void setLoadClasses(boolean loadClasses) {
        this.m_loadClasses = loadClasses;
    }

    private IFileParser getParser(String fileName) {
        IFileParser<XmlSuite> result = DEFAULT_FILE_PARSER;
        if (fileName.endsWith(".xml")) {
            result = XML_PARSER;
        } else if (fileName.endsWith(".yaml")) {
            result = YAML_PARSER;
        }
        return result;
    }

    public Collection<XmlSuite> parse() throws ParserConfigurationException, SAXException, IOException {
        List processedSuites = Lists.newArrayList();
        XmlSuite resultSuite = null;
        List<String> toBeParsed = Lists.newArrayList();
        List<String> toBeAdded = Lists.newArrayList();
        List<String> toBeRemoved = Lists.newArrayList();
        if (this.m_fileName != null) {
            File mainFile = new File(this.m_fileName);
            toBeParsed.add(mainFile.getCanonicalPath());
        }
        Map<String, XmlSuite> childToParentMap = Maps.newHashMap();
        while (toBeParsed.size() > 0) {
            for (String currentFile : toBeParsed) {
                List<String> suiteFiles;
                File currFile = new File(currentFile);
                File parentFile = currFile.getParentFile();
                InputStream inputStream = this.m_inputStream != null ? this.m_inputStream : new FileInputStream(currentFile);
                IFileParser fileParser = this.getParser(currentFile);
                XmlSuite currentXmlSuite = (XmlSuite)fileParser.parse(currentFile, inputStream, this.m_loadClasses);
                processedSuites.add(currentFile);
                toBeRemoved.add(currentFile);
                if (childToParentMap.containsKey(currentFile)) {
                    XmlSuite parentSuite = (XmlSuite)childToParentMap.get(currentFile);
                    currentXmlSuite.setParentSuite(parentSuite);
                    parentSuite.getChildSuites().add(currentXmlSuite);
                }
                if (null == resultSuite) {
                    resultSuite = currentXmlSuite;
                }
                if ((suiteFiles = currentXmlSuite.getSuiteFiles()).size() <= 0) continue;
                for (String path : suiteFiles) {
                    String canonicalPath = parentFile != null && new File(parentFile, path).exists() ? new File(parentFile, path).getCanonicalPath() : new File(path).getCanonicalPath();
                    if (processedSuites.contains(canonicalPath)) continue;
                    toBeAdded.add(canonicalPath);
                    childToParentMap.put(canonicalPath, currentXmlSuite);
                }
            }
            for (String s : toBeRemoved) {
                toBeParsed.remove(s);
            }
            toBeRemoved = Lists.newArrayList();
            for (String s : toBeAdded) {
                toBeParsed.add(s);
            }
            toBeAdded = Lists.newArrayList();
        }
        List<XmlSuite> resultList = Lists.newArrayList();
        resultList.add(resultSuite);
        boolean postProcess = true;
        if (postProcess && this.m_postProcessor != null) {
            return this.m_postProcessor.process(resultList);
        }
        return resultList;
    }

    public List<XmlSuite> parseToList() throws ParserConfigurationException, SAXException, IOException {
        List<XmlSuite> result = Lists.newArrayList();
        Collection<XmlSuite> suites = this.parse();
        for (XmlSuite suite : suites) {
            result.add(suite);
        }
        return result;
    }
}

