/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonPrettyGeneratorImpl;
import org.glassfish.json.api.BufferPool;

class JsonWriterImpl
implements JsonWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final JsonGeneratorImpl generator;
    private boolean writeDone;
    private final NoFlushOutputStream os;

    JsonWriterImpl(Writer writer, BufferPool bufferPool) {
        this(writer, false, bufferPool);
    }

    JsonWriterImpl(Writer writer, boolean bl, BufferPool bufferPool) {
        this.generator = bl ? new JsonPrettyGeneratorImpl(writer, bufferPool) : new JsonGeneratorImpl(writer, bufferPool);
        this.os = null;
    }

    JsonWriterImpl(OutputStream outputStream, BufferPool bufferPool) {
        this(outputStream, UTF_8, false, bufferPool);
    }

    JsonWriterImpl(OutputStream outputStream, boolean bl, BufferPool bufferPool) {
        this(outputStream, UTF_8, bl, bufferPool);
    }

    JsonWriterImpl(OutputStream outputStream, Charset charset, boolean bl, BufferPool bufferPool) {
        this.os = new NoFlushOutputStream(outputStream);
        this.generator = bl ? new JsonPrettyGeneratorImpl(this.os, charset, bufferPool) : new JsonGeneratorImpl(this.os, charset, bufferPool);
    }

    @Override
    public void writeArray(JsonArray jsonArray) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue jsonValue : jsonArray) {
            this.generator.write(jsonValue);
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    @Override
    public void writeObject(JsonObject jsonObject) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            this.generator.write((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    @Override
    public void write(JsonStructure jsonStructure) {
        if (jsonStructure instanceof JsonArray) {
            this.writeArray((JsonArray)jsonStructure);
        } else {
            this.writeObject((JsonObject)jsonStructure);
        }
    }

    @Override
    public void close() {
        this.writeDone = true;
        this.generator.close();
    }

    private static final class NoFlushOutputStream
    extends FilterOutputStream {
        public NoFlushOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        @Override
        public void flush() {
        }
    }
}

