/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.XmlWriter;

public abstract class AbstractDownloadTask<T>
implements DownloadTask {
    private List<Object> errorMessages = new ArrayList<Object>();
    private boolean canceled;
    private boolean failed;
    protected T downloadedData;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean bl) {
        this.failed = bl;
    }

    protected final void rememberErrorMessage(String string) {
        this.errorMessages.add(string);
    }

    protected final void rememberException(Exception exception) {
        this.errorMessages.add(exception);
    }

    protected final void rememberDownloadedData(T t) {
        this.downloadedData = t;
    }

    public final T getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public List<Object> getErrorObjects() {
        return this.errorMessages;
    }

    @Override
    public String acceptsDocumentationSummary() {
        StringBuilder stringBuilder = new StringBuilder("<tr><td>");
        stringBuilder.append(this.getTitle()).append(":</td><td>");
        String[] stringArray = this.getPatterns();
        if (stringArray.length > 0) {
            stringBuilder.append("<ul>");
            for (String string : stringArray) {
                stringBuilder.append("<li>").append(XmlWriter.encode(string)).append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        stringBuilder.append("</td></tr>");
        return stringBuilder.toString();
    }

    public boolean acceptsUrl(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.getPatterns()) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isSafeForRemotecontrolRequests() {
        return false;
    }

    @Override
    public boolean acceptsUrl(String string, boolean bl) {
        if (bl && !this.isSafeForRemotecontrolRequests()) {
            return false;
        }
        return this.acceptsUrl(string);
    }

    @Override
    public String getTitle() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public String[] getPatterns() {
        return new String[0];
    }
}

