/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.text.MessageFormat;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public final class JosmUserIdentityManager
implements Preferences.PreferenceChangedListener {
    private static JosmUserIdentityManager instance;
    private String userName;
    private UserInfo userInfo;
    private boolean accessTokenKeyChanged;
    private boolean accessTokenSecretChanged;

    public static synchronized JosmUserIdentityManager getInstance() {
        if (instance == null) {
            instance = new JosmUserIdentityManager();
            if (OsmApi.isUsingOAuth() && OAuthAccessTokenHolder.getInstance().containsAccessToken() && !Main.isOffline(OnlineResource.OSM_API)) {
                try {
                    instance.initFromOAuth();
                }
                catch (Exception exception) {
                    Main.error(exception);
                    instance.initFromPreferences();
                }
            } else {
                instance.initFromPreferences();
            }
            Main.pref.addPreferenceChangeListener(instance);
        }
        return instance;
    }

    private JosmUserIdentityManager() {
    }

    public void setAnonymous() {
        this.userName = null;
        this.userInfo = null;
    }

    public void setPartiallyIdentified(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "userName");
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", string));
        }
        this.userName = string;
        this.userInfo = null;
    }

    public void setFullyIdentified(String string, UserInfo userInfo) {
        CheckParameterUtil.ensureParameterNotNull(string, "username");
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("Expected non-empty value for parameter ''{0}'', got ''{1}''", "userName", this.userName));
        }
        CheckParameterUtil.ensureParameterNotNull(userInfo, "userinfo");
        this.userName = string;
        this.userInfo = userInfo;
    }

    public boolean isAnonymous() {
        return this.userName == null && this.userInfo == null;
    }

    public boolean isPartiallyIdentified() {
        return this.userName != null && this.userInfo == null;
    }

    public boolean isFullyIdentified() {
        return this.userName != null && this.userInfo != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserId() {
        if (this.userInfo == null) {
            return 0;
        }
        return this.userInfo.getId();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void initFromPreferences() {
        String string = CredentialsManager.getInstance().getUsername();
        if (this.isAnonymous()) {
            if (string != null && !string.trim().isEmpty()) {
                this.setPartiallyIdentified(string);
            }
        } else if (string != null && !string.equals(this.userName)) {
            this.setPartiallyIdentified(string);
        }
    }

    public void initFromOAuth() {
        try {
            UserInfo userInfo = new OsmServerUserInfoReader().fetchUserInfo(NullProgressMonitor.INSTANCE);
            this.setFullyIdentified(userInfo.getDisplayName(), userInfo);
        }
        catch (IllegalArgumentException | OsmTransferException exception) {
            Main.error(exception);
        }
    }

    public boolean isCurrentUser(String string) {
        if (string == null || this.userName == null) {
            return false;
        }
        return this.userName.equals(string);
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        switch (preferenceChangeEvent.getKey()) {
            case "osm-server.username": {
                String string = null;
                if (preferenceChangeEvent.getNewValue() instanceof Preferences.StringSetting) {
                    string = (String)((Preferences.StringSetting)preferenceChangeEvent.getNewValue()).getValue();
                }
                if (string == null || string.trim().isEmpty()) {
                    this.setAnonymous();
                } else if (!string.equals(this.userName)) {
                    this.setPartiallyIdentified(string);
                }
                return;
            }
            case "osm-server.url": {
                String string = null;
                if (preferenceChangeEvent.getNewValue() instanceof Preferences.StringSetting) {
                    string = (String)((Preferences.StringSetting)preferenceChangeEvent.getNewValue()).getValue();
                }
                if (string == null || string.trim().isEmpty()) {
                    this.setAnonymous();
                    break;
                }
                if (!this.isFullyIdentified()) break;
                this.setPartiallyIdentified(this.getUserName());
                break;
            }
            case "oauth.access-token.key": {
                this.accessTokenKeyChanged = true;
                break;
            }
            case "oauth.access-token.secret": {
                this.accessTokenSecretChanged = true;
            }
        }
        if (this.accessTokenKeyChanged && this.accessTokenSecretChanged) {
            this.accessTokenKeyChanged = false;
            this.accessTokenSecretChanged = false;
            if (OsmApi.isUsingOAuth()) {
                try {
                    JosmUserIdentityManager.getInstance().initFromOAuth();
                }
                catch (Exception exception) {
                    Main.error(exception);
                }
            }
        }
    }
}

