/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverTable;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberConflictResolver
extends JPanel {
    private AutoCompletingTextField tfRole;
    private AutoCompletingTextField tfKey;
    private AutoCompletingTextField tfValue;
    private JCheckBox cbTagRelations;
    private final RelationMemberConflictResolverModel model;
    private RelationMemberConflictResolverTable tblResolver;
    private JMultilineLabel lblHeader;

    protected final void build() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.lblHeader = new JMultilineLabel("");
        jPanel.add(this.lblHeader);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.tblResolver = new RelationMemberConflictResolverTable(this.model);
        this.add((Component)new JScrollPane(this.tblResolver), gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.buildRoleEditingPanel());
        jPanel.add(this.buildTagRelationsPanel());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
    }

    protected JPanel buildRoleEditingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(I18n.tr("Role:", new Object[0])));
        this.tfRole = new AutoCompletingTextField(10);
        jPanel.add(this.tfRole);
        this.tfRole.setToolTipText(I18n.tr("Enter a role for all relation memberships", new Object[0]));
        jPanel.add(new JButton(new ApplyRoleAction()));
        this.tfRole.addActionListener(new ApplyRoleAction());
        this.tfRole.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                RelationMemberConflictResolver.this.tfRole.selectAll();
            }
        });
        return jPanel;
    }

    protected JPanel buildTagRelationsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.cbTagRelations = new JCheckBox(I18n.tr("Tag modified relations with ", new Object[0]));
        this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
        this.cbTagRelations.setToolTipText(I18n.tr("<html>Select to enable entering a tag which will be applied<br>to all modified relations.</html>", new Object[0]));
        jPanel.add(this.cbTagRelations);
        jPanel.add(new JLabel(I18n.trc("tag", "Key:")));
        this.tfKey = new AutoCompletingTextField(10);
        jPanel.add(this.tfKey);
        this.tfKey.setToolTipText(I18n.tr("<html>Enter a tag key, e.g. <strong><tt>fixme</tt></strong></html>", new Object[0]));
        jPanel.add(new JLabel(I18n.tr("Value:", new Object[0])));
        this.tfValue = new AutoCompletingTextField(10);
        jPanel.add(this.tfValue);
        this.tfValue.setToolTipText(I18n.tr("<html>Enter a tag value, e.g. <strong><tt>check members</tt></strong></html>", new Object[0]));
        this.cbTagRelations.setSelected(false);
        this.tfKey.setEnabled(false);
        this.tfValue.setEnabled(false);
        return jPanel;
    }

    public RelationMemberConflictResolver(RelationMemberConflictResolverModel relationMemberConflictResolverModel) {
        this.model = relationMemberConflictResolverModel;
        this.build();
    }

    public void initForWayCombining() {
        this.lblHeader.setText(I18n.tr("<html>The combined ways are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the combined way or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first way and <strong>remove</strong> the other ways that are members of the same relation: the combined way will take the place of the original way in the relation.</html>", new Object[0]));
        this.invalidate();
    }

    public void initForNodeMerging() {
        this.lblHeader.setText(I18n.tr("<html>The merged nodes are members in one or more relations. Please decide whether you want to <strong>keep</strong> these memberships for the target node or whether you want to <strong>remove</strong> them.<br>The default is to <strong>keep</strong> the first node and <strong>remove</strong> the other nodes that are members of the same relation: the target node will take the place of the original node in the relation.</html>", new Object[0]));
        this.invalidate();
    }

    public RelationMemberConflictResolverModel getModel() {
        return this.model;
    }

    public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> collection) {
        if (!this.cbTagRelations.isSelected()) {
            return null;
        }
        if (this.tfKey.getText().trim().isEmpty()) {
            return null;
        }
        if (this.tfValue.getText().trim().isEmpty()) {
            return null;
        }
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(collection, Tag.removeWhiteSpaces(this.tfKey.getText()), Tag.removeWhiteSpaces(this.tfValue.getText()));
    }

    public void prepareForEditing() {
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithMemberRoles(autoCompletionList);
        this.tfRole.setAutoCompletionList(autoCompletionList);
        AutoCompletingTextField autoCompletingTextField = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
        if (autoCompletingTextField != null) {
            autoCompletingTextField.setAutoCompletionList(autoCompletionList);
        }
        AutoCompletionList autoCompletionList2 = new AutoCompletionList();
        Main.main.getEditLayer().data.getAutoCompletionManager().populateWithKeys(autoCompletionList2);
        this.tfKey.setAutoCompletionList(autoCompletionList2);
    }

    class ToggleTagRelationsAction
    implements ChangeListener {
        ToggleTagRelationsAction() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = ((AbstractButton)changeEvent.getSource()).getModel();
            RelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            RelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
        }
    }

    class ApplyRoleAction
    extends AbstractAction {
        ApplyRoleAction() {
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Apply this role to all members", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RelationMemberConflictResolver.this.model.applyRole(RelationMemberConflictResolver.this.tfRole.getText());
        }
    }
}

