/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OAuthAccessTokenHolder {
    private static OAuthAccessTokenHolder instance;
    private boolean saveToPreferences;
    private String accessTokenKey;
    private String accessTokenSecret;

    public static synchronized OAuthAccessTokenHolder getInstance() {
        if (instance == null) {
            instance = new OAuthAccessTokenHolder();
        }
        return instance;
    }

    public boolean isSaveToPreferences() {
        return this.saveToPreferences;
    }

    public void setSaveToPreferences(boolean bl) {
        this.saveToPreferences = bl;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public void setAccessTokenKey(String string) {
        this.accessTokenKey = string;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String string) {
        this.accessTokenSecret = string;
    }

    public OAuthToken getAccessToken() {
        if (!this.containsAccessToken()) {
            return null;
        }
        return new OAuthToken(this.accessTokenKey, this.accessTokenSecret);
    }

    public void setAccessToken(String string, String string2) {
        this.accessTokenKey = string;
        this.accessTokenSecret = string2;
    }

    public void setAccessToken(OAuthToken oAuthToken) {
        if (oAuthToken == null) {
            this.accessTokenKey = null;
            this.accessTokenSecret = null;
        } else {
            this.accessTokenKey = oAuthToken.getKey();
            this.accessTokenSecret = oAuthToken.getSecret();
        }
    }

    public boolean containsAccessToken() {
        return this.accessTokenKey != null && this.accessTokenSecret != null;
    }

    public void init(Preferences preferences, CredentialsAgent credentialsAgent) {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        CheckParameterUtil.ensureParameterNotNull(credentialsAgent, "cm");
        OAuthToken oAuthToken = null;
        try {
            oAuthToken = credentialsAgent.lookupOAuthAccessToken();
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
            Main.warn(I18n.tr("Failed to retrieve OAuth Access Token from credential manager", new Object[0]));
            Main.warn(I18n.tr("Current credential manager is of type ''{0}''", credentialsAgent.getClass().getName()));
        }
        this.saveToPreferences = preferences.getBoolean("oauth.access-token.save-to-preferences", true);
        if (oAuthToken != null) {
            this.accessTokenKey = oAuthToken.getKey();
            this.accessTokenSecret = oAuthToken.getSecret();
        }
    }

    public void save(Preferences preferences, CredentialsAgent credentialsAgent) {
        CheckParameterUtil.ensureParameterNotNull(preferences, "preferences");
        CheckParameterUtil.ensureParameterNotNull(credentialsAgent, "cm");
        preferences.put("oauth.access-token.save-to-preferences", this.saveToPreferences);
        try {
            if (!this.saveToPreferences) {
                credentialsAgent.storeOAuthAccessToken(null);
            } else {
                credentialsAgent.storeOAuthAccessToken(new OAuthToken(this.accessTokenKey, this.accessTokenSecret));
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
            Main.warn(I18n.tr("Failed to store OAuth Access Token to credentials manager", new Object[0]));
            Main.warn(I18n.tr("Current credential manager is of type ''{0}''", credentialsAgent.getClass().getName()));
        }
    }

    public void clear() {
        this.accessTokenKey = null;
        this.accessTokenSecret = null;
    }
}

