// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Base, BufferInStream, Command, E, TrackSubSubCommand, User, add_option_dict, dict_union, env, iced, log, make_esc, master_ring, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  add_option_dict = require('./argparse').add_option_dict;

  E = require('../err').E;

  TrackSubSubCommand = require('../tracksubsub').TrackSubSubCommand;

  BufferInStream = require('iced-spawn').BufferInStream;

  master_ring = require('../keyring').master_ring;

  make_esc = require('iced-error').make_esc;

  dict_union = require('../util').dict_union;

  User = require('../user').User;

  env = require('../env').env;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = dict_union(TrackSubSubCommand.OPTS, {
      s: {
        alias: "sign",
        action: "storeTrue",
        help: "sign in addition to encrypting"
      },
      m: {
        alias: "message",
        help: "provide the message on the command line"
      },
      b: {
        alias: 'binary',
        action: "storeTrue",
        help: "output in binary (rather than ASCII/armored)"
      },
      o: {
        alias: 'output',
        help: 'the output file to write the encryption to'
      }
    });

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: ["enc"],
        help: "encrypt a message and output to stdout or a file"
      };
      name = "encrypt";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      sub.addArgument(["them"], {
        nargs: 1,
        help: "the username of the receiver"
      });
      sub.addArgument(["file"], {
        nargs: '?',
        help: "the file to be encrypted"
      });
      return opts.aliases.concat([name]);
    };

    Command.prototype.do_encrypt = function(cb) {
      var args, err, gargs, key, o, out, sign_key, ___iced_passed_deferral, __iced_deferrals, __iced_k, _i, _len, _ref;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = ["--encrypt", "--trust-mode", "always"];
      _ref = this.them.gpg_keys;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        key = _ref[_i];
        args = args.concat("-r", key.fingerprint().toString('hex'));
      }
      if (this.argv.sign) {
        sign_key = this.is_self ? this.them : this.tssc.me;
        args.push("--sign", "-u", sign_key.fingerprint(true));
      }
      gargs = {
        args: args
      };
      gargs.quiet = true;
      if ((o = this.argv.output)) {
        args.push("--output", o, "--yes");
      }
      if (!this.argv.binary) {
        args.push("-a");
      }
      if (this.argv.message) {
        gargs.stdin = new BufferInStream(this.argv.message);
      } else if (this.argv.file != null) {
        args.push(this.argv.file);
      } else {
        gargs.stdin = process.stdin;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/encrypt.iced",
            funcname: "Command.do_encrypt"
          });
          master_ring().gpg(gargs, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 70
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (_this.argv.output == null) {
              (function(__iced_k) {
                if (_this.argv.binary) {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/jacko/node-client/src/command/encrypt.iced",
                      funcname: "Command.do_encrypt"
                    });
                    process.stdout.write(out, __iced_deferrals.defer({
                      lineno: 73
                    }));
                    __iced_deferrals._fulfill();
                  })(__iced_k);
                } else {
                  return __iced_k(log.console.log(out.toString('utf8')));
                }
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err);
          });
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var assertions, batch, esc, them_un, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      batch = !this.argv.message && (this.argv.file == null);
      if (this.argv.sign && !env().is_configured()) {
        cb(new Error("You can't sign messages when you aren't logged in."));
        return;
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/jacko/node-client/src/command/encrypt.iced",
            funcname: "Command.run"
          });
          User.resolve_user_name({
            username: _this.argv.them[0]
          }, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                them_un = arguments[0];
                return assertions = arguments[1];
              };
            })(),
            lineno: 91
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (env().is_me(them_un)) {
              _this.is_self = true;
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/command/encrypt.iced",
                  funcname: "Command.run"
                });
                User.load_me({
                  secret: true
                }, esc(__iced_deferrals.defer({
                  assign_fn: (function(__slot_1) {
                    return function() {
                      return __slot_1.them = arguments[0];
                    };
                  })(_this),
                  lineno: 95
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              _this.is_self = false;
              _this.tssc = new TrackSubSubCommand({
                args: {
                  them: them_un
                },
                opts: _this.argv,
                batch: batch,
                assertions: assertions
              });
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/jacko/node-client/src/command/encrypt.iced",
                  funcname: "Command.run"
                });
                _this.tssc.pre_encrypt(esc(__iced_deferrals.defer({
                  lineno: 99
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return __iced_k(_this.them = _this.tssc.them);
              });
            }
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/jacko/node-client/src/command/encrypt.iced",
                funcname: "Command.run"
              });
              _this.do_encrypt(esc(__iced_deferrals.defer({
                lineno: 101
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null);
            });
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
