/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableRange;
import writer2latex.office.TableReader;
import writer2latex.office.TableView;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

public class TableConverter
extends ConverterHelper {
    protected Vector<String> sheetNames = new Vector();

    public TableConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter);
    }

    public void convertTableContent(Element onode) {
        Element hnode = null;
        if (!onode.hasChildNodes()) {
            return;
        }
        if (!this.config.xhtmlCalcSplit()) {
            hnode = this.nextOutFile();
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        for (int i = 0; i < nLen; ++i) {
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() != 1 || !(sNodeName = child.getNodeName()).equals("table:table")) continue;
            StyleWithProperties style = this.ofr.getTableStyle(Misc.getAttribute(child, "table:style-name"));
            if (!this.config.xhtmlDisplayHiddenSheets() && style != null && "false".equals(style.getProperty("table:display")) || this.config.applyPrintRanges() && this.ofr.getTableReader((Element)child).getPrintRangeCount() <= 0) continue;
            if (this.config.xhtmlCalcSplit()) {
                hnode = this.nextOutFile();
            }
            String sName = Misc.getAttribute(child, "table:name");
            this.sheetNames.add(sName);
            if (this.config.xhtmlUseSheetNamesAsHeadings()) {
                Element heading = this.converter.createElement("h2");
                hnode.appendChild(heading);
                heading.setAttribute("id", "tableheading" + (this.sheetNames.size() - 1));
                heading.appendChild(this.converter.createTextNode(sName));
            }
            this.handleTable(child, hnode);
            Element div = this.converter.createElement("div");
            Element shapes = Misc.getChildByTagName(child, "table:shapes");
            if (shapes != null) {
                for (Node shape = shapes.getFirstChild(); shape != null; shape = shape.getNextSibling()) {
                    if (!OfficeReader.isDrawElement(shape)) continue;
                    this.getDrawCv().handleDrawElement((Element)shape, div, null, 3);
                }
            }
            this.getDrawCv().flushFrames(div);
            if (!div.hasChildNodes()) continue;
            hnode.appendChild(div);
        }
        if (this.converter.getOutFileIndex() < 0) {
            this.nextOutFile();
        }
    }

    private Element nextOutFile() {
        String sTitle;
        Element hnode = this.converter.nextOutFile();
        if (this.config.xhtmlUseTitleAsHeading() && (sTitle = this.converter.getMetaData().getTitle()) != null) {
            Element title = this.converter.createElement("h1");
            hnode.appendChild(title);
            title.appendChild(this.converter.createTextNode(sTitle));
        }
        return hnode;
    }

    public void handleTable(Node onode, Node hnode) {
        TableReader tblr = this.ofr.getTableReader((Element)onode);
        if (this.config.applyPrintRanges()) {
            if (tblr.getPrintRangeCount() > 0) {
                Element div = this.converter.createElement("div");
                if (!tblr.isSubTable()) {
                    this.converter.addTarget(div, tblr.getTableName() + "|table");
                }
                hnode.appendChild(div);
                int nCount = tblr.getPrintRangeCount();
                for (int nRange = 0; nRange < nCount; ++nRange) {
                    Element table = this.createTable(tblr);
                    div.appendChild(table);
                    TableRange range = tblr.getPrintRange(nRange);
                    range.setIncludeHidden(this.config.displayHiddenRowsCols());
                    range.setIncludeFiltered(this.config.displayFilteredRowsCols());
                    this.traverseTable(range.createTableView(), table);
                }
            }
        } else {
            Element table = this.createTable(tblr);
            if (!tblr.isSubTable()) {
                this.converter.addTarget(table, tblr.getTableName() + "|table");
            }
            hnode.appendChild(table);
            TableRange range = new TableRange(tblr);
            if (this.ofr.isSpreadsheet()) {
                range.setLastRow(tblr.getMaxRowCount() - 1);
                range.setLastCol(tblr.getMaxColCount() - 1);
            }
            range.setIncludeHidden(this.config.displayHiddenRowsCols());
            range.setIncludeFiltered(this.config.displayFilteredRowsCols());
            this.traverseTable(range.createTableView(), table);
        }
    }

    private Element createTable(TableReader tblr) {
        Element table = this.converter.createElement("table");
        table.setAttribute("cellspacing", "0");
        this.applyTableStyle(tblr.getTableStyleName(), table, tblr.isSubTable());
        return table;
    }

    private void traverseTable(TableView view, Element hnode) {
        int nBodyStart;
        int nRowCount = view.getRowCount();
        int nColCount = view.getColCount();
        boolean bFirstRowColSpan = false;
        for (int nCol = 0; nCol < nColCount; ++nCol) {
            String sColSpan;
            Element cell = view.getCell(0, nCol);
            if (cell == null || !"table:table-cell".equals(cell.getNodeName()) || Misc.getPosInteger(sColSpan = Misc.getAttribute((Node)cell, "table:number-columns-spanned"), 1) <= 1) continue;
            bFirstRowColSpan = true;
        }
        if (this.config.tableSize() != 0 && (view.getRelTableWidth() != null || this.config.tableSize() == 2 || bFirstRowColSpan)) {
            Element col;
            Element colgroup = hnode;
            if (this.converter.nType == 3) {
                colgroup = this.converter.createElement("colgroup");
                hnode.appendChild(colgroup);
            }
            if (view.getRelTableWidth() != null || this.config.tableSize() == 2) {
                for (int nCol = 0; nCol < nColCount; ++nCol) {
                    col = this.converter.createElement("col");
                    colgroup.appendChild(col);
                    col.setAttribute("style", "width:" + view.getRelColumnWidth(nCol));
                }
            } else if (bFirstRowColSpan) {
                for (int nCol = 0; nCol < nColCount; ++nCol) {
                    col = this.converter.createElement("col");
                    colgroup.appendChild(col);
                    col.setAttribute("style", "width:" + this.getTableSc().colScale(view.getColumnWidth(nCol)));
                }
            }
        }
        for (nBodyStart = 0; nBodyStart < nRowCount && view.getRow(nBodyStart).isHeader(); ++nBodyStart) {
        }
        if (nBodyStart == 0 || nBodyStart == nRowCount) {
            Element tbody = hnode;
            if (this.converter.nType == 3) {
                tbody = this.converter.createElement("tbody");
                hnode.appendChild(tbody);
            }
            this.traverseRows(view, 0, nRowCount, tbody);
        } else {
            Element thead = this.converter.createElement("thead");
            hnode.appendChild(thead);
            this.traverseRows(view, 0, nBodyStart, thead);
            Element tbody = this.converter.createElement("tbody");
            hnode.appendChild(tbody);
            this.traverseRows(view, nBodyStart, nRowCount, tbody);
        }
    }

    private void traverseRows(TableView view, int nFirstRow, int nLastRow, Element hnode) {
        for (int nRow = nFirstRow; nRow < nLastRow; ++nRow) {
            Element tr = this.converter.createElement("tr");
            hnode.appendChild(tr);
            this.applyRowStyle(view.getRow(nRow).getStyleName(), tr);
            for (int nCol = 0; nCol < view.getColCount(); ++nCol) {
                Element cell = view.getCell(nRow, nCol);
                if (cell == null) continue;
                if ("table:table-cell".equals(cell.getNodeName())) {
                    int nColSpan;
                    Element td = this.converter.createElement("td");
                    tr.appendChild(td);
                    int nRowSpan = view.getRowSpan(nRow, nCol);
                    if (nRowSpan > 1) {
                        td.setAttribute("rowspan", Integer.toString(nRowSpan));
                    }
                    if ((nColSpan = view.getColSpan(nRow, nCol)) > 1) {
                        td.setAttribute("colspan", Integer.toString(nColSpan));
                    }
                    if (!this.isEmptyCell(cell)) {
                        String sWidth = view.getCellWidth(nRow, nCol);
                        if (sWidth != null) {
                            this.converter.pushContentWidth(sWidth);
                        }
                        this.getTextCv().traverseBlockText(cell, td);
                        if (sWidth != null) {
                            this.converter.popContentWidth();
                        }
                    } else {
                        Element par = this.converter.createElement("p");
                        td.appendChild(par);
                        par.setAttribute("style", "margin:0;font-size:1px");
                        par.appendChild(this.converter.createTextNode("\u00a0"));
                    }
                    Element subTable = Misc.getChildByTagName(cell, "table:sub-table");
                    String sTotalWidth = null;
                    if (nColSpan == 1) {
                        sTotalWidth = view.getCellWidth(nRow, nCol);
                    }
                    String sValueType = this.ofr.isOpenDocument() ? Misc.getAttribute((Node)cell, "office:value-type") : Misc.getAttribute((Node)cell, "table:value-type");
                    this.applyCellStyle(view.getCellStyleName(nRow, nCol), view.getRelTableWidth() != null, sTotalWidth, sValueType, td, subTable != null);
                    continue;
                }
                if (!"table:covered-table-cell".equals(cell.getNodeName())) continue;
            }
        }
    }

    private boolean isEmptyCell(Node cell) {
        if (!cell.hasChildNodes()) {
            return true;
        }
        if (OfficeReader.isSingleParagraph(cell)) {
            Element par = Misc.getChildByTagName(cell, "text:p");
            return par == null || !par.hasChildNodes();
        }
        return false;
    }

    private void applyTableStyle(String sStyleName, Element table, boolean bIsSubTable) {
        StyleWithProperties style;
        StyleInfo info = new StyleInfo();
        this.getTableSc().applyStyle(sStyleName, info);
        if (this.config.tableSize() != 0 && (style = this.ofr.getTableStyle(sStyleName)) != null) {
            String sWidth = style.getProperty("style:rel-width");
            if (sWidth != null) {
                info.props.addValue("width", sWidth);
            } else {
                sWidth = style.getProperty("style:width");
                if (sWidth != null) {
                    if (this.config.tableSize() == 2) {
                        sWidth = Misc.divide(sWidth, this.converter.getContentWidth(), true);
                        info.props.addValue("width", sWidth);
                    } else {
                        info.props.addValue("width", this.getTableSc().colScale(sWidth));
                    }
                }
            }
        }
        info.props.addValue("border-collapse", "separate");
        info.props.addValue("border-spacing", "0");
        info.props.addValue("table-layout", "fixed");
        if (this.ofr.isSpreadsheet()) {
            info.props.addValue("white-space", "nowrap");
        }
        if (bIsSubTable) {
            info.props.addValue("width", "100%");
            info.props.addValue("margin", "0");
        }
        this.applyStyle(info, table);
    }

    private void applyRowStyle(String sStyleName, Element row) {
        String s;
        StyleWithProperties style;
        StyleInfo info = new StyleInfo();
        this.getRowSc().applyStyle(sStyleName, info);
        if (this.config.tableSize() != 0 && (style = this.ofr.getRowStyle(sStyleName)) != null && (s = style.getAbsoluteProperty("style:row-height")) != null) {
            info.props.addValue("height", this.getRowSc().scale(s));
        }
        this.applyStyle(info, row);
    }

    private void applyCellStyle(String sStyleName, boolean bIsRelative, String sTotalWidth, String sValueType, Element cell, boolean bIsSubTable) {
        StyleInfo info = new StyleInfo();
        this.getCellSc().applyStyle(sStyleName, info);
        StyleWithProperties style = this.ofr.getCellStyle(sStyleName);
        if (style != null) {
            if (this.config.tableSize() == 1 && !bIsRelative) {
                String sEdge = "0";
                String s = style.getProperty("fo:padding-left");
                if (s != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(s));
                }
                if ((s = style.getProperty("fo:padding-right")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(s));
                }
                if ((s = style.getProperty("fo:padding")) != null) {
                    sEdge = Misc.add(sEdge, Misc.multiply("200%", this.getTableSc().colScale(s)));
                }
                if ((s = style.getProperty("fo:border-left")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(this.borderWidth(s)));
                }
                if ((s = style.getProperty("fo:border-right")) != null) {
                    sEdge = Misc.add(sEdge, this.getTableSc().colScale(this.borderWidth(s)));
                }
                if ((s = style.getProperty("fo:border")) != null) {
                    sEdge = Misc.add(sEdge, Misc.multiply("200%", this.getTableSc().colScale(this.borderWidth(s))));
                }
                if (sTotalWidth != null) {
                    info.props.addValue("width", Misc.sub(this.getTableSc().colScale(sTotalWidth), sEdge));
                }
            }
            if (this.ofr.isSpreadsheet() && !"fix".equals(style.getProperty("style:text-align-source"))) {
                info.props.addValue("text-align", sValueType == null || "string".equals(sValueType) ? "left" : "right");
            }
        }
        if (!cell.hasChildNodes()) {
            cell.appendChild(this.converter.createTextNode("\u00a0"));
        }
        if (bIsSubTable) {
            info.props.addValue("vertical-align", "top");
            info.props.addValue("padding", "0");
        }
        this.applyStyle(info, cell);
    }

    public String borderWidth(String sBorder) {
        if (sBorder == null || sBorder.equals("none")) {
            return "0";
        }
        SimpleInputBuffer in = new SimpleInputBuffer(sBorder);
        while (in.peekChar() != '\u0000') {
            while (in.peekChar() == ' ') {
                in.getChar();
            }
            if ('0' <= in.peekChar() && in.peekChar() <= '9') {
                return in.getNumber() + in.getIdentifier();
            }
            while (in.peekChar() != ' ' && in.peekChar() != '\u0000') {
            }
        }
        return "0";
    }
}

