/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.selector;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.bus.selector.ClassSelector;
import reactor.bus.selector.MatchAllSelector;
import reactor.bus.selector.ObjectSelector;
import reactor.bus.selector.PredicateSelector;
import reactor.bus.selector.RegexSelector;
import reactor.bus.selector.Selector;
import reactor.bus.selector.SetMembershipSelector;
import reactor.bus.selector.UriPathSelector;
import reactor.bus.selector.UriSelector;
import reactor.fn.Predicate;

public abstract class Selectors {
    private static final AtomicInteger HASH_CODES = new AtomicInteger(Integer.MIN_VALUE);

    public static Selector anonymous() {
        AnonymousKey obj = new AnonymousKey();
        return Selectors.$(obj);
    }

    public static Selector $() {
        return Selectors.anonymous();
    }

    public static <T> Selector<T> object(T obj) {
        return new ObjectSelector(obj);
    }

    public static <T> Selector<T> $(T obj) {
        return Selectors.object(obj);
    }

    public static Selector $(String fmt, Object ... args) {
        return Selectors.object(String.format(fmt, args));
    }

    public static Selector regex(String regex) {
        return new RegexSelector(regex);
    }

    public static Selector R(String regex) {
        return new RegexSelector(regex);
    }

    public static ClassSelector type(Class<?> supertype) {
        return new ClassSelector(supertype);
    }

    public static ClassSelector T(Class<?> supertype) {
        return Selectors.type(supertype);
    }

    public static Selector uri(String uri) {
        if (null == uri) {
            return null;
        }
        switch (uri.charAt(0)) {
            case '/': {
                return new UriPathSelector(uri);
            }
        }
        return new UriSelector(uri);
    }

    public static Selector U(String uri) {
        return Selectors.uri(uri);
    }

    public static Selector predicate(Predicate<Object> predicate) {
        return new PredicateSelector(predicate);
    }

    public static Selector matchAll() {
        return new MatchAllSelector();
    }

    public static Selector setMembership(Set set) {
        return new SetMembershipSelector(set);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return HASH_CODES;
    }

    public static class AnonymousKey {
        private final int hashCode = Selectors.access$000().getAndIncrement() << 2;

        public int hashCode() {
            return this.hashCode;
        }
    }
}

