/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec;

import java.util.List;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.reactivestreams.PublisherFactory;
import reactor.core.reactivestreams.SubscriberBarrier;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.buffer.Buffer;

public abstract class Codec<SRC, IN, OUT>
implements Function<OUT, SRC> {
    public static final byte DEFAULT_DELIMITER = 0;
    protected final Byte delimiter;

    protected Codec() {
        this((byte)0);
    }

    protected Codec(Byte delimiter) {
        this.delimiter = delimiter;
    }

    public Publisher<IN> decode(Publisher<? extends SRC> publisherToDecode) {
        return PublisherFactory.intercept(publisherToDecode, new Function<Subscriber<? super IN>, SubscriberBarrier<SRC, IN>>(){

            @Override
            public SubscriberBarrier<SRC, IN> apply(Subscriber<? super IN> subscriber) {
                return new DecoderBarrier(subscriber);
            }
        });
    }

    public Function<SRC, IN> decoder() {
        return this.decoder(null);
    }

    public abstract Function<SRC, IN> decoder(Consumer<IN> var1);

    public Publisher<SRC> encode(Publisher<? extends OUT> publisherToEncode) {
        return PublisherFactory.intercept(publisherToEncode, new Function<Subscriber<? super SRC>, SubscriberBarrier<OUT, SRC>>(){

            @Override
            public SubscriberBarrier<OUT, SRC> apply(Subscriber<? super SRC> subscriber) {
                return new EncoderBarrier(subscriber);
            }
        });
    }

    public Function<OUT, SRC> encoder() {
        return this;
    }

    protected IN doDelimitedBufferDecode(Consumer<IN> decoderCallback, Buffer buffer) {
        if (this.delimiter != null) {
            List<Buffer.View> views = buffer.split(this.delimiter.byteValue());
            int viewCount = views.size();
            if (viewCount == 0) {
                return Codec.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(buffer));
            }
            for (Buffer.View view : views) {
                IN in = Codec.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(view.get()));
                if (in == null) continue;
                return in;
            }
            return null;
        }
        return Codec.invokeCallbackOrReturn(decoderCallback, this.doBufferDecode(buffer));
    }

    protected static <IN> IN invokeCallbackOrReturn(Consumer<IN> consumer, IN v) {
        if (consumer != null) {
            consumer.accept(v);
            return null;
        }
        return v;
    }

    protected IN doBufferDecode(Buffer buffer) {
        return null;
    }

    protected Buffer addDelimiterIfAny(Buffer buffer) {
        if (this.delimiter != null) {
            return buffer.append(this.delimiter).flip();
        }
        return buffer;
    }

    private class EncoderBarrier
    extends SubscriberBarrier<OUT, SRC> {
        private final Function<OUT, SRC> encoder;

        public EncoderBarrier(Subscriber<? super SRC> subscriber) {
            super(subscriber);
            this.encoder = Codec.this.encoder();
        }

        @Override
        protected void doNext(OUT src) {
            this.subscriber.onNext(this.encoder.apply(src));
        }
    }

    private final class DecoderBarrier
    extends SubscriberBarrier<SRC, IN> {
        final Function<SRC, IN> decoder;

        public DecoderBarrier(final Subscriber<? super IN> subscriber) {
            super(subscriber);
            this.decoder = Codec.this.decoder(new Consumer<IN>(){

                @Override
                public void accept(IN in) {
                    subscriber.onNext(in);
                }
            });
        }

        @Override
        protected void doNext(SRC src) {
            this.decoder.apply(src);
        }
    }
}

