/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToByteFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.LongBytePredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongByteMap;
import com.gs.collections.api.map.primitive.LongByteMap;
import com.gs.collections.api.map.primitive.MutableLongByteMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.LongByteMaps;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongByteMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableLongByteMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongByteHashMap
implements MutableLongByteMap,
Externalizable {
    static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public LongByteHashMap() {
        this.allocateTable(16);
    }

    public LongByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public LongByteHashMap(LongByteMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static LongByteHashMap newWithKeysValues(long key1, byte value1) {
        return new LongByteHashMap(1).withKeyValue(key1, value1);
    }

    public static LongByteHashMap newWithKeysValues(long key1, byte value1, long key2, byte value2) {
        return new LongByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongByteHashMap newWithKeysValues(long key1, byte value1, long key2, byte value2, long key3, byte value3) {
        return new LongByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongByteHashMap newWithKeysValues(long key1, byte value1, long key2, byte value2, long key3, byte value3, long key4, byte value4) {
        return new LongByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongByteMap)) {
            return false;
        }
        LongByteMap other = (LongByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0L)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1L)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongByteHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                long key = this.keys[i];
                if (!LongByteHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    public boolean containsAll(byte ... source) {
        for (byte each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy(new BytePredicate(){

            public boolean accept(byte value) {
                return LongByteHashMap.this.contains(value);
            }
        });
    }

    public void forEach(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableByteCollection select(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableByteCollection reject(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public byte detectIfNone(BytePredicate predicate, byte value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, (byte)0);
    }

    public void put(long key, byte value) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(LongByteMap map) {
        map.forEachKeyValue(new LongByteProcedure(){

            public void value(long key, byte value) {
                LongByteHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(long key) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(long key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(long key, byte value) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            byte oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(long key, byte value) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPut(long key, ByteFunction0 function) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> byte getIfAbsentPutWith(long key, ByteFunction<? super P> function, P parameter) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.byteValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.byteValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.byteValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte getIfAbsentPutWithKey(long key, LongToByteFunction function) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        byte value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public byte addToValue(long key, byte toBeAdded) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (byte)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (byte)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (byte)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(long key, byte value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(byte value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = (byte)0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(byte value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = (byte)0;
        } else {
            this.sentinelValues = null;
        }
    }

    public byte updateValue(long key, byte initialValueIfAbsent, ByteToByteFunction function) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        byte value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public LongByteHashMap withKeyValue(long key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public LongByteHashMap withKeysValues(long key1, byte value1, long key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongByteHashMap withKeysValues(long key1, byte value1, long key2, byte value2, long key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongByteHashMap withKeysValues(long key1, byte value1, long key2, byte value2, long key3, byte value3, long key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public LongByteHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public LongByteHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(new LongProcedure(){

            public void value(long key) {
                LongByteHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableLongByteMap asUnmodifiable() {
        return new UnmodifiableLongByteMap(this);
    }

    public MutableLongByteMap asSynchronized() {
        return new SynchronizedLongByteMap(this);
    }

    public ImmutableLongByteMap toImmutable() {
        return LongByteMaps.immutable.ofAll((LongByteMap)this);
    }

    public byte get(long key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(long key, byte ifAbsent) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public byte getOrThrow(long key) {
        if (LongByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        if (LongByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(byte value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (long key : this.keys) {
            if (!LongByteHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(LongByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongBytePair> keyValuesView() {
        return new KeyValuesView();
    }

    public LongByteHashMap select(LongBytePredicate predicate) {
        LongByteHashMap result = new LongByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public LongByteHashMap reject(LongBytePredicate predicate) {
        LongByteHashMap result = new LongByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteIterator iterator = this.byteIterator();
        byte max = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteIterator iterator = this.byteIterator();
        byte min = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(long element) {
        int index = this.spread(element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1L) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0L) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(long element) {
        long code = element;
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongByteHashMap.isEmptyKey(key) && !LongByteHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ long[] access$802(LongByteHashMap x0, long[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1002(LongByteHashMap x0, byte[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<LongBytePair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super LongBytePair> procedure) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongByteHashMap.this.sentinelValues.zeroValue));
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongByteHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongByteHashMap.this.keys[i], LongByteHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super LongBytePair> objectIntProcedure) {
            int index = 0;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0L, LongByteHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1L, LongByteHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(LongByteHashMap.this.keys[i], LongByteHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super LongBytePair, ? super P> procedure, P parameter) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongByteHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongByteHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongByteHashMap.this.keys[i], LongByteHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<LongBytePair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<LongBytePair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongBytePair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongByteHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, LongByteHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongByteHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, LongByteHashMap.this.sentinelValues.oneValue);
                    }
                }
                long[] keys = LongByteHashMap.this.keys;
                while (!LongByteHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongBytePair result = PrimitiveTuples.pair(keys[this.position], LongByteHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongByteHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableByteCollection {
        private ValuesCollection() {
        }

        public void clear() {
            LongByteHashMap.this.clear();
        }

        public MutableByteCollection select(BytePredicate predicate) {
            return LongByteHashMap.this.select(predicate);
        }

        public MutableByteCollection reject(BytePredicate predicate) {
            return LongByteHashMap.this.reject(predicate);
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return LongByteHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return LongByteHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            return LongByteHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return LongByteHashMap.this.sum();
        }

        public byte max() {
            return LongByteHashMap.this.max();
        }

        public byte maxIfEmpty(byte defaultValue) {
            return LongByteHashMap.this.maxIfEmpty(defaultValue);
        }

        public byte min() {
            return LongByteHashMap.this.min();
        }

        public byte minIfEmpty(byte defaultValue) {
            return LongByteHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return LongByteHashMap.this.average();
        }

        public double median() {
            return LongByteHashMap.this.median();
        }

        public byte[] toSortedArray() {
            return LongByteHashMap.this.toSortedArray();
        }

        public MutableByteList toSortedList() {
            return LongByteHashMap.this.toSortedList();
        }

        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll((ByteIterable)this);
        }

        public boolean contains(byte value) {
            return LongByteHashMap.this.containsValue(value);
        }

        public boolean containsAll(byte ... source) {
            return LongByteHashMap.this.containsAll(source);
        }

        public boolean containsAll(ByteIterable source) {
            return LongByteHashMap.this.containsAll(source);
        }

        public MutableByteList toList() {
            return LongByteHashMap.this.toList();
        }

        public MutableByteSet toSet() {
            return LongByteHashMap.this.toSet();
        }

        public MutableByteBag toBag() {
            return LongByteHashMap.this.toBag();
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public boolean isEmpty() {
            return LongByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongByteHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongByteHashMap.this.sentinelValues != null) {
                    if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(LongByteHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(LongByteHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                    long key = LongByteHashMap.this.keys[i];
                    if (!LongByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(LongByteHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return LongByteHashMap.this.byteIterator();
        }

        public void forEach(ByteProcedure procedure) {
            LongByteHashMap.this.forEach(procedure);
        }

        public int count(BytePredicate predicate) {
            return LongByteHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BytePredicate predicate) {
            return LongByteHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BytePredicate predicate) {
            return LongByteHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            return LongByteHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(byte item) {
            int oldSize = LongByteHashMap.this.size();
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && item == LongByteHashMap.this.sentinelValues.zeroValue) {
                    LongByteHashMap.this.removeKey(0L);
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && item == LongByteHashMap.this.sentinelValues.oneValue) {
                    LongByteHashMap.this.removeKey(1L);
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i]) || item != LongByteHashMap.this.values[i]) continue;
                LongByteHashMap.this.removeKey(LongByteHashMap.this.keys[i]);
            }
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = LongByteHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = LongByteHashMap.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean retainAll(ByteIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
            LongByteHashMap retained = LongByteHashMap.this.select(new LongBytePredicate((ByteSet)sourceSet){
                final /* synthetic */ ByteSet val$sourceSet;
                {
                    this.val$sourceSet = byteSet;
                }

                public boolean accept(long key, byte value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                LongByteHashMap.access$802(LongByteHashMap.this, retained.keys);
                LongByteHashMap.access$1002(LongByteHashMap.this, retained.values);
                LongByteHashMap.this.sentinelValues = retained.sentinelValues;
                LongByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(byte ... source) {
            return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
        }

        public int size() {
            return LongByteHashMap.this.size();
        }

        public byte[] toArray() {
            return LongByteHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableLongSet {
        private KeySet() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongByteHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return false;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(long key) {
            int oldSize = LongByteHashMap.this.size();
            LongByteHashMap.this.removeKey(key);
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongByteHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                LongByteHashMap.this.removeKey(iterator.next());
            }
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongByteHashMap.this.size();
            for (long item : source) {
                LongByteHashMap.this.removeKey(item);
            }
            return oldSize != LongByteHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            LongByteHashMap retained = LongByteHashMap.this.select(new LongBytePredicate((LongSet)sourceSet){
                final /* synthetic */ LongSet val$sourceSet;
                {
                    this.val$sourceSet = longSet;
                }

                public boolean accept(long key, byte value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                LongByteHashMap.access$802(LongByteHashMap.this, retained.keys);
                LongByteHashMap.access$1002(LongByteHashMap.this, retained.values);
                LongByteHashMap.this.sentinelValues = retained.sentinelValues;
                LongByteHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongByteHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
        }

        public void clear() {
            LongByteHashMap.this.clear();
        }

        public MutableLongSet select(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet reject(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0L));
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1L));
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableLongSet asUnmodifiable() {
            return UnmodifiableLongSet.of(this);
        }

        public MutableLongSet asSynchronized() {
            return SynchronizedLongSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (long key : LongByteHashMap.this.keys) {
                if (!LongByteHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public long max() {
            if (LongByteHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 0L;
            boolean isMaxSet = false;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0L;
                    isMaxSet = true;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1L)) {
                    max = 1L;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i]) || isMaxSet && max >= LongByteHashMap.this.keys[i]) continue;
                max = LongByteHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (LongByteHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (LongByteHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = 0L;
            boolean isMinSet = false;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0L;
                    isMinSet = true;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1L < min)) {
                    min = 1L;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i]) || isMinSet && LongByteHashMap.this.keys[i] >= min) continue;
                min = LongByteHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (LongByteHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public long[] toArray() {
            int size = LongByteHashMap.this.size();
            final long[] result = new long[size];
            LongByteHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(long value) {
            return LongByteHashMap.this.containsKey(value);
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (LongByteHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (LongByteHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0L);
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1L);
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i])) continue;
                result = function.valueOf(result, LongByteHashMap.this.keys[i]);
            }
            return result;
        }

        public LongSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableLongSet toImmutable() {
            return LongSets.immutable.withAll((LongIterable)this);
        }

        public int size() {
            return LongByteHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongByteHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (LongByteHashMap.this.sentinelValues != null) {
                if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < LongByteHashMap.this.keys.length; ++i) {
                if (!LongByteHashMap.isNonSentinel(LongByteHashMap.this.keys[i])) continue;
                result += (int)(LongByteHashMap.this.keys[i] ^ LongByteHashMap.this.keys[i] >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongByteHashMap.this.sentinelValues != null) {
                    if (LongByteHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongByteHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongByteHashMap.this.keys) {
                    if (!LongByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < LongByteHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongByteHashMap.this.containsKey(0L)) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongByteHashMap.this.containsKey(1L)) {
                    return 1L;
                }
            }
            long[] keys = LongByteHashMap.this.keys;
            while (!LongByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongByteHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalByteIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < LongByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongByteHashMap.this.containsKey(0L)) {
                    return LongByteHashMap.this.get(0L);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongByteHashMap.this.containsKey(1L)) {
                    return LongByteHashMap.this.get(1L);
                }
            }
            long[] keys = LongByteHashMap.this.keys;
            while (!LongByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = LongByteHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private byte zeroValue;
        private byte oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(byte value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

