/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.io.IOUtils;
import grails.util.BuildSettings;
import grails.util.CollectionUtils;
import grails.util.Holder;
import grails.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    APPLICATION,
    CUSTOM;

    public static String KEY;
    public static String ENV_GRAILS_HOME;
    public static String RELOAD_ENABLED;
    public static String FULL_STACKTRACE;
    public static final String RELOAD_LOCATION = "grails.reload.location";
    public static final String INTERACTIVE_MODE_ENABLED = "grails.interactive.mode.enabled";
    public static final String DEFAULT = "grails.env.default";
    public static final String INITIALIZING = "grails.env.initializing";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static Map<String, String> envNameMappings;
    private static Holder<Environment> cachedCurrentEnvironment;
    private static final boolean DEVELOPMENT_MODE;
    private static boolean initializingState;
    public static Throwable currentReloadError;
    public static MultipleCompilationErrorsException currentCompilationError;
    private String name;
    private String reloadLocation;
    private static Boolean reloadingAgentEnabled;

    private Environment() {
        this.initialize();
    }

    public static void setCurrentReloadError(Throwable currentReloadError) {
        Environment.currentReloadError = currentReloadError;
    }

    public static MultipleCompilationErrorsException getCurrentCompilationError() {
        return currentCompilationError;
    }

    public static Throwable getCurrentReloadError() {
        return currentReloadError;
    }

    public static boolean isReloadInProgress() {
        return Boolean.getBoolean("grails.reloading.in.progress");
    }

    private void initialize() {
        this.name = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static Environment getCurrent() {
        Environment current = cachedCurrentEnvironment.get();
        if (current != null) {
            return current;
        }
        return Environment.resolveCurrentEnvironment();
    }

    private static Environment resolveCurrentEnvironment() {
        Environment env;
        String envName = System.getProperty(KEY);
        if (Environment.isBlank(envName)) {
            Metadata metadata = Metadata.getCurrent();
            if (metadata != null) {
                envName = metadata.getEnvironment();
            }
            if (Environment.isBlank(envName)) {
                return DEVELOPMENT;
            }
        }
        if ((env = Environment.getEnvironment(envName)) == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    public static void cacheCurrentEnvironment() {
        cachedCurrentEnvironment.set(Environment.resolveCurrentEnvironment());
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static boolean isDevelopmentMode() {
        return DEVELOPMENT_MODE;
    }

    public static boolean isDevelopmentEnvironmentAvailable() {
        return BuildSettings.GRAILS_APP_DIR_PRESENT;
    }

    public static boolean isWarDeployed() {
        URL loadedLocation = Environment.class.getClassLoader().getResource("application.yml");
        return loadedLocation != null && loadedLocation.getPath().contains("/WEB-INF/classes");
    }

    public static boolean isFork() {
        return Boolean.getBoolean("grails.fork.active");
    }

    public static boolean isWithinShell() {
        return DefaultGroovyMethods.getRootLoader((ClassLoader)Environment.class.getClassLoader()) != null;
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        try {
            return Environment.valueOf(shortName.toUpperCase());
        }
        catch (IllegalArgumentException ise) {
            return null;
        }
    }

    public static Closure<?> getEnvironmentSpecificBlock(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure<?> getEnvironmentSpecificBlock(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.getCallable();
    }

    public static Object executeForCurrentEnvironment(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.execute();
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure<?> closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReloadEnabled() {
        boolean reloadOverride = Boolean.getBoolean(RELOAD_ENABLED);
        this.getReloadLocation();
        boolean reloadLocationSpecified = this.hasLocation(this.reloadLocation);
        return this == DEVELOPMENT && reloadLocationSpecified || reloadOverride && reloadLocationSpecified;
    }

    public static boolean isInteractiveMode() {
        return Boolean.getBoolean(INTERACTIVE_MODE_ENABLED);
    }

    public static boolean isInitializing() {
        return initializingState;
    }

    public static void setInitializing(boolean initializing) {
        initializingState = initializing;
        System.setProperty(INITIALIZING, String.valueOf(initializing));
    }

    public static boolean isReloadingAgentEnabled() {
        if (reloadingAgentEnabled != null) {
            return reloadingAgentEnabled;
        }
        try {
            Class.forName("org.springsource.loaded.TypeRegistry");
            reloadingAgentEnabled = Environment.getCurrent().isReloadEnabled();
        }
        catch (ClassNotFoundException e) {
            reloadingAgentEnabled = false;
        }
        return reloadingAgentEnabled;
    }

    public String getReloadLocation() {
        if (this.reloadLocation != null) {
            return this.reloadLocation;
        }
        String location = this.getReloadLocationInternal();
        if (this.hasLocation(location)) {
            this.reloadLocation = location;
            return location;
        }
        return ".";
    }

    private boolean hasLocation(String location) {
        return location != null && location.length() > 0;
    }

    public boolean hasReloadLocation() {
        this.getReloadLocation();
        return this.hasLocation(this.reloadLocation);
    }

    private String getReloadLocationInternal() {
        String location = System.getProperty(RELOAD_LOCATION);
        if (!this.hasLocation(location)) {
            location = System.getProperty("base.dir");
        }
        if (!this.hasLocation(location)) {
            File current = new File(".", "grails-app");
            if (current.exists()) {
                location = current.getParentFile().getAbsolutePath();
            } else {
                current = new File(".", "settings.gradle");
                if (current.exists()) {
                    location = IOUtils.findApplicationDirectory();
                }
            }
        }
        return location;
    }

    static {
        KEY = "grails.env";
        ENV_GRAILS_HOME = "GRAILS_HOME";
        RELOAD_ENABLED = "grails.reload.enabled";
        FULL_STACKTRACE = "grails.full.stacktrace";
        envNameMappings = CollectionUtils.newMap(DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName(), PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName(), TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
        cachedCurrentEnvironment = new Holder("Environment");
        DEVELOPMENT_MODE = Environment.getCurrent() == DEVELOPMENT && BuildSettings.GRAILS_APP_DIR_PRESENT;
        initializingState = false;
        currentReloadError = null;
        currentCompilationError = null;
        reloadingAgentEnabled = null;
    }

    private static class EnvironmentBlockEvaluator
    extends GroovyObjectSupport {
        private Environment current;
        private Closure<?> callable;

        public Closure<?> getCallable() {
            return this.callable;
        }

        Object execute() {
            return this.callable == null ? null : this.callable.call();
        }

        private EnvironmentBlockEvaluator(Environment e) {
            this.current = e;
        }

        public void environments(Closure<?> c) {
            if (c != null) {
                c.setDelegate((Object)this);
                c.call();
            }
        }

        public void production(Closure<?> c) {
            if (this.current == PRODUCTION) {
                this.callable = c;
            }
        }

        public void development(Closure<?> c) {
            if (this.current == DEVELOPMENT) {
                this.callable = c;
            }
        }

        public void test(Closure<?> c) {
            if (this.current == TEST) {
                this.callable = c;
            }
        }

        public Object methodMissing(String name, Object args) {
            Object[] argsArray = (Object[])args;
            if (args != null && argsArray.length > 0 && argsArray[0] instanceof Closure) {
                if (this.current == CUSTOM && this.current.getName().equals(name)) {
                    this.callable = (Closure)argsArray[0];
                }
                return null;
            }
            throw new MissingMethodException(name, Environment.class, argsArray);
        }
    }
}

