/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class XmlVaspReader
extends XmlReader {
    private SB data;
    private String name;
    private int ac;
    private int iAtom;
    private boolean isE_wo_entrp = false;
    private boolean isE_fr_energy = false;
    private String enthalpy = null;
    private String gibbsEnergy = null;
    private String[] myAttributes = new String[]{"name"};
    boolean haveUnitCell = false;
    String[] atomNames;
    String[] atomSyms;
    String atomName;
    String atomSym;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;

    @Override
    protected String[] getDOMAttributes() {
        return this.myAttributes;
    }

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.doProcessLines = true;
        this.PX(xmlReader, object);
    }

    @Override
    public void processStartElement(String string) {
        if (this.debugging) {
            Logger.debug("xmlvasp: start " + string);
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("calculation".equals(string)) {
            this.enthalpy = null;
            this.gibbsEnergy = null;
            return;
        }
        if ("i".equals(string)) {
            String string2 = (String)this.atts.get("name");
            if (string2.charAt(0) != 'e') {
                return;
            }
            this.isE_wo_entrp = string2.equals("e_wo_entrp");
            this.isE_fr_energy = string2.equals("e_fr_energy");
            this.keepChars = this.isE_wo_entrp || this.isE_fr_energy;
            return;
        }
        if ("structure".equals(string)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.asc.doFixPeriodic = true;
            this.asc.newAtomSet();
            if (this.enthalpy != null) {
                this.asc.setCurrentModelInfo("enthalpy", PT.dVal(this.enthalpy));
            }
            if (this.gibbsEnergy != null) {
                this.asc.setAtomSetEnergy("" + this.gibbsEnergy, this.parseFloatStr(this.gibbsEnergy));
                this.asc.setCurrentModelInfo("gibbsEnergy", PT.dVal(this.gibbsEnergy));
            }
            if (this.enthalpy != null && this.gibbsEnergy != null) {
                this.asc.setAtomSetName("Enthalpy = " + this.enthalpy + " eV Gibbs Energy = " + this.gibbsEnergy + " eV");
            }
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
        if ("v".equals(string)) {
            this.keepChars = this.data != null;
            return;
        }
        if ("c".equals(string)) {
            this.keepChars = this.iAtom < this.ac;
            return;
        }
        if ("varray".equals(string)) {
            this.name = (String)this.atts.get("name");
            if (this.name != null && PT.isOneOf(this.name, ";basis;positions;forces;")) {
                this.data = new SB();
            }
            return;
        }
        if ("atoms".equals(string)) {
            this.keepChars = true;
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if (this.debugging) {
            Logger.debug("xmlvasp: end " + string);
        }
        if (this.parent.doProcessLines) {
            if (this.isE_wo_entrp) {
                this.isE_wo_entrp = false;
                this.enthalpy = this.chars.trim();
            } else if (this.isE_fr_energy) {
                this.isE_fr_energy = false;
                this.gibbsEnergy = this.chars.trim();
            } else if ("v".equals(string) && this.data != null) {
                this.data.append(this.chars);
            } else if ("c".equals(string)) {
                if (this.iAtom < this.ac) {
                    if (this.atomName == null) {
                        this.atomName = this.atomSym = this.chars.trim();
                    } else {
                        this.atomNames[this.iAtom++] = this.atomName + this.chars.trim();
                        this.atomName = null;
                    }
                }
            } else if ("atoms".equals(string)) {
                this.ac = this.parseIntStr(this.chars);
                this.atomNames = new String[this.ac];
                this.atomSyms = new String[this.ac];
                this.iAtom = 0;
            } else if ("varray".equals(string) && this.data != null) {
                if (this.name != null) {
                    if ("basis".equals(this.name) && !this.haveUnitCell) {
                        this.haveUnitCell = true;
                        float[] fArray = XmlVaspReader.getTokensFloat(this.data.toString(), null, 9);
                        V3 v3 = V3.new3(fArray[0], fArray[1], fArray[2]);
                        V3 v32 = V3.new3(fArray[3], fArray[4], fArray[5]);
                        V3 v33 = V3.new3(fArray[6], fArray[7], fArray[8]);
                        this.a = v3.length();
                        this.b = v32.length();
                        this.c = v33.length();
                        v3.normalize();
                        v32.normalize();
                        v33.normalize();
                        this.alpha = (float)(Math.acos(v32.dot(v33)) * 180.0 / Math.PI);
                        this.beta = (float)(Math.acos(v3.dot(v33)) * 180.0 / Math.PI);
                        this.gamma = (float)(Math.acos(v3.dot(v32)) * 180.0 / Math.PI);
                    } else if ("positions".equals(this.name)) {
                        this.parent.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
                        float[] fArray = new float[this.ac * 3];
                        XmlVaspReader.getTokensFloat(this.data.toString(), fArray, this.ac * 3);
                        int n = 0;
                        for (int i = 0; i < this.ac; ++i) {
                            Atom atom = this.asc.addNewAtom();
                            this.parent.setAtomCoordXYZ(atom, fArray[n++], fArray[n++], fArray[n++]);
                            atom.elementSymbol = this.atomSyms[i];
                            atom.atomName = this.atomNames[i];
                        }
                    } else if ("forces".equals(this.name)) {
                        float[] fArray = new float[this.ac * 3];
                        XmlVaspReader.getTokensFloat(this.data.toString(), fArray, this.ac * 3);
                        int n = 0;
                        int n2 = this.asc.getLastAtomSetAtomIndex();
                        for (int i = 0; i < this.ac; ++i) {
                            this.asc.addVibrationVector(n2 + i, fArray[n++], fArray[n++], fArray[n++]);
                        }
                    }
                }
                this.data = null;
            } else if ("structure".equals(string)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }
}

