/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.conflict.pair.nodes.NodeListTable;
import org.openstreetmap.josm.gui.conflict.pair.relation.RelationMemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ZoomToAction
extends AbstractAction
implements MapView.LayerChangeListener,
ListSelectionListener {
    private final OsmPrimitivesTable table;
    private final String descriptionNominal;
    private final String descriptionInactiveLayer;
    private final String descriptionNoSelection;

    public ZoomToAction(OsmPrimitivesTable osmPrimitivesTable, String string, String string2, String string3) {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitivesTable);
        this.table = osmPrimitivesTable;
        this.descriptionNominal = string;
        this.descriptionInactiveLayer = string2;
        this.descriptionNoSelection = string3;
        this.putValue("Name", I18n.tr("Zoom to", new Object[0]));
        this.putValue("ShortDescription", string);
        this.updateEnabledState();
    }

    public ZoomToAction(MemberTable memberTable) {
        this(memberTable, I18n.tr("Zoom to the object the first selected member refers to", new Object[0]), I18n.tr("Zooming disabled because layer of this relation is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected member", new Object[0]));
    }

    public ZoomToAction(RelationMemberTable relationMemberTable) {
        this(relationMemberTable, I18n.tr("Zoom to the object the first selected member refers to", new Object[0]), I18n.tr("Zooming disabled because layer of this relation is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected member", new Object[0]));
    }

    public ZoomToAction(NodeListTable nodeListTable) {
        this(nodeListTable, I18n.tr("Zoom to the first selected node", new Object[0]), I18n.tr("Zooming disabled because layer of this way is not active", new Object[0]), I18n.tr("Zooming disabled because there is no selected node", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = nArray[0];
        OsmDataLayer osmDataLayer = this.table.getLayer();
        OsmPrimitive osmPrimitive = this.table.getPrimitiveInLayer(n, osmDataLayer);
        if (osmDataLayer != null && osmPrimitive != null) {
            osmDataLayer.data.setSelected(osmPrimitive);
            AutoScaleAction.autoScale("selection");
        }
    }

    protected final void updateEnabledState() {
        if (Main.main == null || Main.main.getEditLayer() != this.table.getLayer()) {
            this.setEnabled(false);
            this.putValue("ShortDescription", this.descriptionInactiveLayer);
            return;
        }
        if (this.table.getSelectedRowCount() == 0) {
            this.setEnabled(false);
            this.putValue("ShortDescription", this.descriptionNoSelection);
            return;
        }
        this.setEnabled(true);
        this.putValue("ShortDescription", this.descriptionNominal);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateEnabledState();
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }
}

