/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeletedStateConflictResolveCommand
extends ConflictResolveCommand {
    private final Conflict<? extends OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public DeletedStateConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, MergeDecisionType mergeDecisionType) {
        this.conflict = conflict;
        this.decision = mergeDecisionType;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in deleted state in {0}", this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.conflict.getMy().isDeleted() || this.conflict.isMyDeleted()) {
                this.deleteMy();
            }
        } else if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
            if (this.conflict.getTheir().isDeleted()) {
                this.deleteMy();
            } else {
                this.conflict.getMy().setDeleted(false);
            }
        } else {
            throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict.", new Object[0]));
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    private void deleteMy() {
        Set<OsmPrimitive> set = this.getLayer().data.unlinkReferencesToPrimitive(this.conflict.getMy());
        for (OsmPrimitive osmPrimitive : set) {
            if (osmPrimitive.isNew() || osmPrimitive.isDeleted()) continue;
            osmPrimitive.setModified(true);
        }
        this.conflict.getMy().setDeleted(true);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
        collection.addAll(this.conflict.getMy().getReferrers());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.conflict == null ? 0 : this.conflict.hashCode());
        n = 31 * n + (this.decision == null ? 0 : this.decision.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeletedStateConflictResolveCommand deletedStateConflictResolveCommand = (DeletedStateConflictResolveCommand)object;
        if (this.conflict == null ? deletedStateConflictResolveCommand.conflict != null : !this.conflict.equals(deletedStateConflictResolveCommand.conflict)) {
            return false;
        }
        return this.decision == deletedStateConflictResolveCommand.decision;
    }
}

