/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;

public class NoteSortDialog
extends ExtendedDialog {
    private JRadioButton defaultSort = new JRadioButton(I18n.tr("Default (open, closed, new)", new Object[0]));
    private JRadioButton userSort = new JRadioButton(I18n.tr("Username", new Object[0]));
    private JRadioButton dateSort = new JRadioButton(I18n.tr("Created date", new Object[0]));
    private JRadioButton lastActionSort = new JRadioButton(I18n.tr("Last change date", new Object[0]));

    public NoteSortDialog(Component component, String string, String string2) {
        super(component, string, new String[]{string2, I18n.tr("Cancel", new Object[0])});
    }

    public void showSortDialog(Comparator<Note> comparator) {
        JLabel jLabel = new JLabel(I18n.tr("Select note sorting method", new Object[0]));
        if (comparator == NoteData.DEFAULT_COMPARATOR) {
            this.defaultSort.setSelected(true);
        } else if (comparator == NoteData.DATE_COMPARATOR) {
            this.dateSort.setSelected(true);
        } else if (comparator == NoteData.USER_COMPARATOR) {
            this.userSort.setSelected(true);
        } else if (comparator == NoteData.LAST_ACTION_COMPARATOR) {
            this.lastActionSort.setSelected(true);
        } else {
            Main.warn("sort mode not recognized");
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.defaultSort);
        buttonGroup.add(this.userSort);
        buttonGroup.add(this.dateSort);
        buttonGroup.add(this.lastActionSort);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(this.defaultSort);
        jPanel.add(this.userSort);
        jPanel.add(this.dateSort);
        jPanel.add(this.lastActionSort);
        this.setContent(jPanel);
        this.showDialog();
    }

    public Comparator<Note> getSelectedComparator() {
        if (this.dateSort.isSelected()) {
            return NoteData.DATE_COMPARATOR;
        }
        if (this.userSort.isSelected()) {
            return NoteData.USER_COMPARATOR;
        }
        if (this.lastActionSort.isSelected()) {
            return NoteData.LAST_ACTION_COMPARATOR;
        }
        return NoteData.DEFAULT_COMPARATOR;
    }
}

