/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

public final class Category {
    private static final int DEFAULT_PRIORITY = 50;
    private final int priority;
    private final String name;
    private final Location location;
    private final boolean defaultOff;

    public Category(String name, int priority, Location location, boolean onByDefault) {
        if (priority < 0 || priority > 100) {
            throw new IllegalArgumentException("priority must be in range 0 - 100: " + priority);
        }
        this.name = name;
        this.priority = priority;
        this.location = location;
        this.defaultOff = !onByDefault;
    }

    Category(String name, int priority) {
        this(name, priority, Location.INTERNAL, true);
    }

    public Category(String name) {
        this(name, Location.INTERNAL);
    }

    public Category(String name, Location location) {
        this(name, 50, location, true);
    }

    public Category(String name, Location location, boolean onByDefault) {
        this(name, 50, location, onByDefault);
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.name;
    }

    public boolean isDefaultOff() {
        return this.defaultOff;
    }

    public Location getLocation() {
        return this.location;
    }

    public static enum Location {
        INTERNAL,
        EXTERNAL;

    }
}

