/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.exists;

import java.io.IOException;
import org.elasticsearch.action.exists.ExistsRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardExistsRequest
extends BroadcastShardRequest {
    private float minScore;
    private BytesReference querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    private long nowInMillis;
    @Nullable
    private String[] filteringAliases;

    ShardExistsRequest() {
    }

    ShardExistsRequest(ShardId shardId, @Nullable String[] filteringAliases, ExistsRequest request) {
        super(shardId, request);
        this.minScore = request.minScore();
        this.querySource = request.source();
        this.types = request.types();
        this.filteringAliases = filteringAliases;
        this.nowInMillis = request.nowInMillis;
    }

    public float minScore() {
        return this.minScore;
    }

    public BytesReference querySource() {
        return this.querySource;
    }

    public String[] types() {
        return this.types;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.querySource = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readString();
            }
        }
        this.nowInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeString(alias);
            }
        } else {
            out.writeVInt(0);
        }
        out.writeVLong(this.nowInMillis);
    }
}

