/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;

public class TypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";

    private TypeFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? TypeFieldMapper.defaultFieldType(indexSettings) : existing.clone(), indexSettings);
    }

    private TypeFieldMapper(MappedFieldType fieldType, Settings indexSettings) {
        super("_type", fieldType, TypeFieldMapper.defaultFieldType(indexSettings), indexSettings);
    }

    private static MappedFieldType defaultFieldType(Settings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        Version indexCreated = Version.indexCreated(indexSettings);
        if (indexCreated.onOrAfter(Version.V_2_1_0)) {
            defaultFieldType.setHasDocValues(true);
        }
        return defaultFieldType;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) {
            return;
        }
        fields.add(new Field(this.fieldType().names().indexName(), context.type(), (FieldType)this.fieldType()));
        if (this.fieldType().hasDocValues()) {
            fields.add((Field)new SortedSetDocValuesField(this.fieldType().names().indexName(), new BytesRef((CharSequence)context.type())));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean defaultIndexed;
        if (!this.indexCreatedBefore2x) {
            return builder;
        }
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean bl = defaultIndexed = Defaults.FIELD_TYPE.indexOptions() != IndexOptions.NONE;
        if (!includeDefaults && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && indexed == defaultIndexed) {
            return builder;
        }
        builder.startObject("_type");
        if (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || indexed != defaultIndexed) {
            builder.field("index", TypeFieldMapper.indexTokenizeOptionToString(indexed, this.fieldType().tokenized()));
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
    }

    static final class TypeFieldType
    extends MappedFieldType {
        public TypeFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected TypeFieldType(TypeFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new TypeFieldType(this);
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryParseContext context) {
            if (this.indexOptions() == IndexOptions.NONE) {
                return new ConstantScoreQuery((Query)new PrefixQuery(new Term("_uid", Uid.typePrefixAsBytes(BytesRefs.toBytesRef(value)))));
            }
            return new ConstantScoreQuery((Query)new TermQuery(this.createTerm(value)));
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
                throw new MapperParsingException("_type is not configurable");
            }
            Builder builder = new Builder(parserContext.mapperService().fullName("_type"));
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new TypeFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TypeFieldMapper> {
        public Builder(MappedFieldType existing) {
            super("_type", existing == null ? Defaults.FIELD_TYPE : existing);
            this.indexName = "_type";
        }

        @Override
        public TypeFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setNames(this.buildNames(context));
            return new TypeFieldMapper(this.fieldType, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_type";
        public static final MappedFieldType FIELD_TYPE = new TypeFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_type"));
            FIELD_TYPE.freeze();
        }
    }
}

