/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class IncludeNestedDocsQuery
extends Query {
    private final BitSetProducer parentFilter;
    private final Query parentQuery;
    private final Query origParentQuery;

    public IncludeNestedDocsQuery(Query parentQuery, BitSetProducer parentFilter) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentFilter = parentFilter;
    }

    IncludeNestedDocsQuery(Query rewrite, Query originalQuery, IncludeNestedDocsQuery previousInstance) {
        this.origParentQuery = originalQuery;
        this.parentQuery = rewrite;
        this.parentFilter = previousInstance.parentFilter;
        this.setBoost(previousInstance.getBoost());
    }

    IncludeNestedDocsQuery(Query originalQuery, IncludeNestedDocsQuery previousInstance) {
        this.origParentQuery = originalQuery;
        this.parentQuery = originalQuery;
        this.parentFilter = previousInstance.parentFilter;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new IncludeNestedDocsWeight(this, this.parentQuery, this.parentQuery.createWeight(searcher, needsScores), this.parentFilter);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            return new IncludeNestedDocsQuery(parentRewrite, this.parentQuery, this);
        }
        return this;
    }

    public String toString(String field) {
        return "IncludeNestedDocsQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof IncludeNestedDocsQuery) {
            IncludeNestedDocsQuery other = (IncludeNestedDocsQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && this.parentFilter.equals(other.parentFilter);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + this.parentFilter.hashCode();
        return hash;
    }

    public Query clone() {
        Query clonedQuery = this.origParentQuery.clone();
        return new IncludeNestedDocsQuery(clonedQuery, this);
    }

    static class IncludeNestedDocsScorer
    extends Scorer {
        final Scorer parentScorer;
        final BitSet parentBits;
        int currentChildPointer = -1;
        int currentParentPointer = -1;
        int currentDoc = -1;

        IncludeNestedDocsScorer(Weight weight, Scorer parentScorer, BitSet parentBits, int currentParentPointer) {
            super(weight);
            this.parentScorer = parentScorer;
            this.parentBits = parentBits;
            this.currentParentPointer = currentParentPointer;
            if (currentParentPointer == 0) {
                this.currentChildPointer = 0;
            } else {
                this.currentChildPointer = this.parentBits.prevSetBit(currentParentPointer - 1);
                this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
            }
            this.currentDoc = this.currentChildPointer;
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return this.parentScorer.getChildren();
        }

        public int nextDoc() throws IOException {
            if (this.currentParentPointer == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.currentChildPointer == this.currentParentPointer) {
                this.currentDoc = this.currentParentPointer;
                this.currentParentPointer = this.parentScorer.nextDoc();
                if (this.currentParentPointer != Integer.MAX_VALUE) {
                    this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                    this.currentChildPointer = this.currentChildPointer == -1 ? this.currentParentPointer : ++this.currentChildPointer;
                }
            } else {
                this.currentDoc = this.currentChildPointer++;
            }
            assert (this.currentDoc != -1);
            return this.currentDoc;
        }

        public int advance(int target) throws IOException {
            if (target == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (target == 0) {
                return this.nextDoc();
            }
            if (target < this.currentParentPointer) {
                this.currentDoc = this.currentParentPointer = this.parentScorer.advance(target);
                if (this.currentParentPointer == Integer.MAX_VALUE) {
                    this.currentDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.currentParentPointer == 0) {
                    this.currentChildPointer = 0;
                } else {
                    this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                    this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
                }
            } else {
                this.currentDoc = this.currentChildPointer++;
            }
            return this.currentDoc;
        }

        public float score() throws IOException {
            return this.parentScorer.score();
        }

        public int freq() throws IOException {
            return this.parentScorer.freq();
        }

        public int docID() {
            return this.currentDoc;
        }

        public long cost() {
            return this.parentScorer.cost();
        }
    }

    static class IncludeNestedDocsWeight
    extends Weight {
        private final Query parentQuery;
        private final Weight parentWeight;
        private final BitSetProducer parentsFilter;

        IncludeNestedDocsWeight(Query query, Query parentQuery, Weight parentWeight, BitSetProducer parentsFilter) {
            super(query);
            this.parentQuery = parentQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
        }

        public void extractTerms(Set<Term> terms) {
            this.parentWeight.extractTerms(terms);
        }

        public void normalize(float norm, float topLevelBoost) {
            this.parentWeight.normalize(norm, topLevelBoost);
        }

        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization();
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(context);
            if (parentScorer == null) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(context);
            if (parents == null) {
                return null;
            }
            int firstParentDoc = parentScorer.nextDoc();
            if (firstParentDoc == Integer.MAX_VALUE) {
                return null;
            }
            return new IncludeNestedDocsScorer(this, parentScorer, parents, firstParentDoc);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return null;
        }
    }
}

