/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class BaseDirFileResolver
extends AbstractFileResolver {
    private final File baseDir;

    public BaseDirFileResolver(FileSystem fileSystem, File baseDir) {
        super(fileSystem);
        assert (baseDir.isAbsolute()) : String.format("base dir '%s' is not an absolute file.", baseDir);
        this.baseDir = baseDir;
    }

    public String resolveAsRelativePath(Object path) {
        int prefixLen;
        List<String> basePath = Arrays.asList(StringUtils.split((String)this.baseDir.getAbsolutePath(), (String)("/" + File.separator)));
        File targetFile = this.resolve(path);
        List<String> targetPath = new ArrayList<String>(Arrays.asList(StringUtils.split((String)targetFile.getAbsolutePath(), (String)("/" + File.separator))));
        int maxDepth = Math.min(basePath.size(), targetPath.size());
        for (prefixLen = 0; prefixLen < maxDepth && basePath.get(prefixLen).equals(targetPath.get(prefixLen)); ++prefixLen) {
        }
        basePath = basePath.subList(prefixLen, basePath.size());
        targetPath = targetPath.subList(prefixLen, targetPath.size());
        for (int i = 0; i < basePath.size(); ++i) {
            targetPath.add(0, "..");
        }
        if (targetPath.isEmpty()) {
            return ".";
        }
        return CollectionUtils.join((String)File.separator, targetPath);
    }

    protected File doResolve(Object path) {
        if (!GUtil.isTrue((Object)path) || !GUtil.isTrue((Object)this.baseDir)) {
            throw new IllegalArgumentException(String.format("Neither path nor baseDir may be null or empty string. path='%s' basedir='%s'", path, this.baseDir));
        }
        File file = this.convertObjectToFile(path);
        if (!file.isAbsolute()) {
            file = new File(this.baseDir, file.getPath());
        }
        return file;
    }
}

