/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection {
    private final Set<Object> files;
    private final String displayName;
    private final FileResolver resolver;
    private final DefaultTaskDependency buildDependency;

    public DefaultConfigurableFileCollection(FileResolver fileResolver, TaskResolver taskResolver, Object ... files) {
        this("file collection", fileResolver, taskResolver, files);
    }

    public DefaultConfigurableFileCollection(String displayName, FileResolver fileResolver, TaskResolver taskResolver, Object ... files) {
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.files = new LinkedHashSet<Object>(Arrays.asList(files));
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<Object> getFrom() {
        return this.files;
    }

    @Override
    public void setFrom(Iterable<?> path) {
        this.files.clear();
        this.files.add(path);
    }

    @Override
    public void setFrom(Object ... paths) {
        this.files.clear();
        GUtil.addToCollection(this.files, (Iterable[])new Iterable[]{Arrays.asList(paths)});
    }

    @Override
    public ConfigurableFileCollection from(Object ... paths) {
        GUtil.addToCollection(this.files, (Iterable[])new Iterable[]{Arrays.asList(paths)});
        return this;
    }

    @Override
    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getValues();
    }

    @Override
    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        FileCollectionResolveContext nested = context.push(this.resolver);
        nested.add(this.files);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.buildDependency);
        super.visitDependencies(context);
    }
}

