/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableCharListFactory;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableCharArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableCharEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableCharSingletonList;

public class ImmutableCharListFactoryImpl
implements ImmutableCharListFactory {
    public ImmutableCharList of() {
        return this.with();
    }

    public ImmutableCharList with() {
        return ImmutableCharEmptyList.INSTANCE;
    }

    public ImmutableCharList of(char one) {
        return this.with(one);
    }

    public ImmutableCharList with(char one) {
        return new ImmutableCharSingletonList(one);
    }

    public ImmutableCharList of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharList with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayList.newListWith(items);
    }

    public ImmutableCharList ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharList withAll(CharIterable items) {
        if (items instanceof ImmutableCharList) {
            return (ImmutableCharList)items;
        }
        return this.with(items.toArray());
    }
}

