/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.api.stack.primitive.MutableCharStack;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableCharStack;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedCharStack
implements MutableCharStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableCharStack stack;

    SynchronizedCharStack(MutableCharStack stack) {
        this(stack, null);
    }

    SynchronizedCharStack(MutableCharStack stack, Object newLock) {
        this.stack = stack;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(char item) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharList pop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharList peek(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.stack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(char ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(CharIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    public CharIterator charIterator() {
        return this.stack.charIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(CharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharStack select(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharStack reject(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char max() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char min() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char minIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char maxIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherStack) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.equals(otherStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyCharIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return new LazyCharIterableAdapter((CharIterable)this);
        }
    }

    public MutableCharStack asUnmodifiable() {
        return new UnmodifiableCharStack(this);
    }

    public MutableCharStack asSynchronized() {
        return this;
    }

    public ImmutableCharStack toImmutable() {
        return CharStacks.immutable.withAllReversed((CharIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.stack.injectInto(injectedValue, function);
        }
    }
}

