/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.internal;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InternalArrayIterate {
    private InternalArrayIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> void forEachWithoutChecks(T[] objectArray, int from, int to, Procedure<? super T> procedure) {
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                procedure.value(objectArray[i]);
            }
        } else {
            for (int i = from; i >= to; --i) {
                procedure.value(objectArray[i]);
            }
        }
    }

    public static <T> void forEachWithIndexWithoutChecks(T[] objectArray, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (from <= to) {
            for (int i = from; i <= to; ++i) {
                objectIntProcedure.value(objectArray[i], i);
            }
        } else {
            for (int i = from; i >= to; --i) {
                objectIntProcedure.value(objectArray[i], i);
            }
        }
    }
}

