/*
 * Decompiled with CFR 0.152.
 */
package reactor.jarjar.com.lmax.disruptor;

import reactor.jarjar.com.lmax.disruptor.AlertException;
import reactor.jarjar.com.lmax.disruptor.FixedSequenceGroup;
import reactor.jarjar.com.lmax.disruptor.Sequence;
import reactor.jarjar.com.lmax.disruptor.SequenceBarrier;
import reactor.jarjar.com.lmax.disruptor.Sequencer;
import reactor.jarjar.com.lmax.disruptor.TimeoutException;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;

final class ProcessingSequenceBarrier
implements SequenceBarrier {
    private final WaitStrategy waitStrategy;
    private final Sequence dependentSequence;
    private volatile boolean alerted = false;
    private final Sequence cursorSequence;
    private final Sequencer sequencer;

    public ProcessingSequenceBarrier(Sequencer sequencer, WaitStrategy waitStrategy, Sequence cursorSequence, Sequence[] dependentSequences) {
        this.sequencer = sequencer;
        this.waitStrategy = waitStrategy;
        this.cursorSequence = cursorSequence;
        this.dependentSequence = 0 == dependentSequences.length ? cursorSequence : new FixedSequenceGroup(dependentSequences);
    }

    @Override
    public long waitFor(long sequence) throws AlertException, InterruptedException, TimeoutException {
        this.checkAlert();
        long availableSequence = this.waitStrategy.waitFor(sequence, this.cursorSequence, this.dependentSequence, this);
        if (availableSequence < sequence) {
            return availableSequence;
        }
        return this.sequencer.getHighestPublishedSequence(sequence, availableSequence);
    }

    @Override
    public long getCursor() {
        return this.dependentSequence.get();
    }

    @Override
    public boolean isAlerted() {
        return this.alerted;
    }

    @Override
    public void alert() {
        this.alerted = true;
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void clearAlert() {
        this.alerted = false;
    }

    @Override
    public void checkAlert() throws AlertException {
        if (this.alerted) {
            throw AlertException.INSTANCE;
        }
    }
}

