/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.support;

import grails.persistence.support.PersistenceContextInterceptor;
import javax.persistence.FlushModeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DatastorePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(DatastorePersistenceContextInterceptor.class);
    protected Datastore datastore;
    protected boolean participate;

    public DatastorePersistenceContextInterceptor(Datastore datastore) {
        this.datastore = datastore;
    }

    public void init() {
        if (TransactionSynchronizationManager.getResource((Object)this.datastore) != null) {
            this.participate = true;
        } else {
            LOG.debug((Object)"Opening single Datastore session in DatastorePersistenceContextInterceptor");
            Session session = this.getSession();
            session.setFlushMode(FlushModeType.AUTO);
            try {
                DatastoreUtils.bindSession((Session)session);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected Session getSession() {
        return DatastoreUtils.getSession((Datastore)this.datastore, (boolean)true);
    }

    public void destroy() {
        if (this.participate) {
            return;
        }
        if (TransactionSynchronizationManager.getResource((Object)this.datastore) != null) {
            SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.datastore);
            LOG.debug((Object)"Closing single Datastore session in DatastorePersistenceContextInterceptor");
            try {
                Session session = holder.getSession();
                DatastoreUtils.closeSession((Session)session);
            }
            catch (RuntimeException ex) {
                LOG.error((Object)"Unexpected exception on closing Datastore Session", (Throwable)ex);
            }
        }
    }

    public void disconnect() {
        this.destroy();
    }

    public void reconnect() {
        this.init();
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void setReadOnly() {
        this.getSession().setFlushMode(FlushModeType.COMMIT);
    }

    public void setReadWrite() {
        this.getSession().setFlushMode(FlushModeType.AUTO);
    }

    public boolean isOpen() {
        try {
            return DatastoreUtils.doGetSession((Datastore)this.datastore, (boolean)false).isConnected();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

