/*
 * Decompiled with CFR 0.152.
 */
package org.grails.commons;

import groovy.lang.Closure;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.grails.commons.GrailsCodecClass;
import org.grails.core.AbstractInjectableGrailsClass;
import org.grails.encoder.CodecFactory;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.CodecMetaClassSupport;
import org.grails.encoder.Decoder;
import org.grails.encoder.DefaultCodecIdentifier;
import org.grails.encoder.Encodeable;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodingState;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.encoder.EncodingStateRegistryLookup;
import org.grails.encoder.EncodingStateRegistryLookupHolder;
import org.grails.encoder.StreamingEncoder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class DefaultGrailsCodecClass
extends AbstractInjectableGrailsClass
implements InitializingBean,
GrailsCodecClass,
Ordered {
    public static final String CODEC = "Codec";
    private Encoder encoder;
    private Decoder decoder;
    private static int instantionCounter = 0;
    private int order = 100 + instantionCounter++;
    private boolean initialized = false;

    public DefaultGrailsCodecClass(Class<?> clazz) {
        super(clazz, CODEC);
    }

    public void afterPropertiesSet() {
        this.initializeCodec();
    }

    private void initializeCodec() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Integer orderSetting = (Integer)this.getPropertyOrStaticPropertyOrFieldValue("order", Integer.class);
        if (orderSetting != null) {
            this.order = orderSetting;
        }
        if (Encoder.class.isAssignableFrom(this.getClazz())) {
            this.encoder = (Encoder)this.getReferenceInstance();
            this.encoder = (Encoder)this.autowireCodecBean(this.encoder);
            if (this.encoder instanceof Ordered) {
                this.order = ((Ordered)this.encoder).getOrder();
            }
        }
        if (Decoder.class.isAssignableFrom(this.getClazz())) {
            this.decoder = (Decoder)this.getReferenceInstance();
            this.decoder = (Decoder)this.autowireCodecBean(this.decoder);
            if (this.decoder instanceof Ordered) {
                this.order = ((Ordered)this.decoder).getOrder();
            }
        }
        if (this.encoder == null && this.decoder == null) {
            CodecFactory codecFactory = null;
            if (CodecFactory.class.isAssignableFrom(this.getClazz())) {
                codecFactory = (CodecFactory)this.getReferenceInstance();
                codecFactory = (CodecFactory)this.autowireCodecBean(codecFactory);
            }
            if (codecFactory == null) {
                codecFactory = (CodecFactory)this.getPropertyOrStaticPropertyOrFieldValue("codecFactory", CodecFactory.class);
                codecFactory = (CodecFactory)this.autowireCodecBean(codecFactory);
            }
            if (codecFactory == null) {
                codecFactory = new ClosureCodecFactory();
            }
            this.encoder = codecFactory.getEncoder();
            this.decoder = codecFactory.getDecoder();
            if (codecFactory instanceof Ordered) {
                this.order = ((Ordered)codecFactory).getOrder();
            }
        }
        if (this.encoder != null) {
            this.encoder = this.encoder instanceof StreamingEncoder ? new StreamingStateAwareEncoderWrapper((StreamingEncoder)this.encoder) : new StateAwareEncoderWrapper(this.encoder);
        }
    }

    protected Object autowireCodecBean(Object existingBean) {
        if (existingBean != null && this.grailsApplication != null && this.grailsApplication.getMainContext() != null) {
            AutowireCapableBeanFactory beanFactory = this.grailsApplication.getMainContext().getAutowireCapableBeanFactory();
            beanFactory.autowireBeanProperties(existingBean, 1, false);
            existingBean = beanFactory.initializeBean(existingBean, "codec");
        }
        return existingBean;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void configureCodecMethods() {
        this.initializeCodec();
        new CodecMetaClassSupport().configureCodecMethods((CodecFactory)this);
    }

    public int getOrder() {
        return this.order;
    }

    private static class MethodCallingClosure
    extends Closure<Object> {
        private static final long serialVersionUID = 1L;
        private Method method;

        public MethodCallingClosure(Object owner, Method method) {
            super(owner);
            this.maximumNumberOfParameters = 1;
            this.parameterTypes = new Class[]{Object.class};
            this.method = method;
        }

        protected Object callMethod(Object argument) {
            return ReflectionUtils.invokeMethod((Method)this.method, (Object)(!Modifier.isStatic(this.method.getModifiers()) ? this.getOwner() : null), (Object[])new Object[]{argument});
        }

        public Object call(Object ... args) {
            return this.doCall(args);
        }

        protected Object doCall(Object[] args) {
            Object target = null;
            if (args != null && args.length > 0) {
                target = args[0];
            }
            if (target == null) {
                return null;
            }
            return this.callMethod(target);
        }
    }

    private static class ClosureEncoder
    implements Encoder {
        private CodecIdentifier codecIdentifier;
        private Closure<Object> closure;

        public ClosureEncoder(String codecName, Closure<Object> closure) {
            this.codecIdentifier = new DefaultCodecIdentifier(codecName);
            this.closure = closure;
        }

        public CodecIdentifier getCodecIdentifier() {
            return this.codecIdentifier;
        }

        public Object encode(Object target) {
            if (target == null) {
                return null;
            }
            return this.closure.call(target);
        }

        public void markEncoded(CharSequence string) {
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isApplyToSafelyEncoded() {
            return true;
        }
    }

    private static class StreamingStateAwareEncoderWrapper
    extends StateAwareEncoderWrapper
    implements StreamingEncoder {
        private StreamingEncoder delegate;

        public StreamingStateAwareEncoderWrapper(StreamingEncoder delegate) {
            super((Encoder)delegate);
            this.delegate = delegate;
        }

        public void encodeToStream(Encoder thisInstance, CharSequence source, int offset, int len, EncodedAppender appender, EncodingState encodingState) throws IOException {
            this.delegate.encodeToStream((Encoder)this, source, offset, len, appender, encodingState);
        }
    }

    private static class StateAwareEncoderWrapper
    implements Encoder {
        private Encoder delegate;

        public StateAwareEncoderWrapper(Encoder delegate) {
            this.delegate = delegate;
        }

        public CodecIdentifier getCodecIdentifier() {
            return this.delegate.getCodecIdentifier();
        }

        public Object encode(Object target) {
            if (target instanceof Encodeable) {
                return ((Encodeable)target).encode((Encoder)this);
            }
            EncodingStateRegistry encodingState = this.lookupEncodingState();
            if (encodingState != null && target instanceof CharSequence && !encodingState.shouldEncodeWith((Encoder)this, (CharSequence)target)) {
                return target;
            }
            Object encoded = this.delegate.encode(target);
            if (encodingState != null && encoded instanceof CharSequence) {
                encodingState.registerEncodedWith((Encoder)this, (CharSequence)encoded);
            }
            return encoded;
        }

        protected EncodingStateRegistry lookupEncodingState() {
            EncodingStateRegistryLookup encodingStateRegistryLookup = EncodingStateRegistryLookupHolder.getEncodingStateRegistryLookup();
            return encodingStateRegistryLookup != null ? encodingStateRegistryLookup.lookup() : null;
        }

        public void markEncoded(CharSequence string) {
            EncodingStateRegistry encodingState = this.lookupEncodingState();
            if (encodingState != null) {
                encodingState.registerEncodedWith((Encoder)this, string);
            }
        }

        public boolean isSafe() {
            return this.delegate.isSafe();
        }

        public boolean isApplyToSafelyEncoded() {
            return this.delegate.isApplyToSafelyEncoded();
        }
    }

    private static class ClosureDecoder
    implements Decoder {
        private CodecIdentifier codecIdentifier;
        private Closure<Object> closure;

        public ClosureDecoder(String codecName, Closure<Object> closure) {
            this.codecIdentifier = new DefaultCodecIdentifier(codecName);
            this.closure = closure;
        }

        public CodecIdentifier getCodecIdentifier() {
            return this.codecIdentifier;
        }

        public Object decode(Object o) {
            return this.closure.call(o);
        }
    }

    private class ClosureCodecFactory
    implements CodecFactory {
        private Encoder encoder;
        private Decoder decoder;

        ClosureCodecFactory() {
            Closure<Object> decoderClosure;
            Closure<Object> encoderClosure = this.getMethodOrClosureMethod(DefaultGrailsCodecClass.this.getClazz(), "encode");
            if (encoderClosure != null) {
                this.encoder = new ClosureEncoder(DefaultGrailsCodecClass.this.getName(), encoderClosure);
            }
            if ((decoderClosure = this.getMethodOrClosureMethod(DefaultGrailsCodecClass.this.getClazz(), "decode")) != null) {
                this.decoder = new ClosureDecoder(DefaultGrailsCodecClass.this.getName(), decoderClosure);
            }
        }

        public Encoder getEncoder() {
            return this.encoder;
        }

        public Decoder getDecoder() {
            return this.decoder;
        }

        private Closure<Object> getMethodOrClosureMethod(Class<?> clazz, String methodName) {
            Closure closure = (Closure)DefaultGrailsCodecClass.this.getPropertyOrStaticPropertyOrFieldValue(methodName, Closure.class);
            if (closure == null) {
                Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])null);
                if (method != null) {
                    Object owner = Modifier.isStatic(method.getModifiers()) ? clazz : DefaultGrailsCodecClass.this.getReferenceInstance();
                    return new MethodCallingClosure(owner, method);
                }
                return null;
            }
            return closure;
        }
    }
}

