/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.validation;

import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEventListener;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.PreUpdateEvent;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.validation.ValidationErrors;
import org.springframework.context.ApplicationEvent;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ValidatingEventListener
extends AbstractPersistenceEventListener {
    public ValidatingEventListener(Datastore datastore) {
        super(datastore);
    }

    @Override
    protected void onPersistenceEvent(AbstractPersistenceEvent event) {
        if (event instanceof PreInsertEvent) {
            this.beforeInsert(event.getEntity(), event.getEntityAccess());
        } else if (event instanceof PreUpdateEvent) {
            this.beforeUpdate(event.getEntity(), event.getEntityAccess());
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return PreInsertEvent.class.isAssignableFrom(eventType) || PreUpdateEvent.class.isAssignableFrom(eventType);
    }

    public boolean beforeInsert(PersistentEntity entity, EntityAccess e) {
        return this.doValidate(entity, e.getEntity());
    }

    public boolean beforeUpdate(PersistentEntity entity, EntityAccess e) {
        return this.doValidate(entity, e.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doValidate(PersistentEntity entity, Object o) {
        Validator v = this.datastore.getMappingContext().getEntityValidator(entity);
        if (v == null) {
            return true;
        }
        if (this.datastore.skipValidation(o)) {
            return true;
        }
        Session currentSession = this.datastore.getCurrentSession();
        FlushModeType flushMode = currentSession.getFlushMode();
        try {
            currentSession.setFlushMode(FlushModeType.COMMIT);
            ValidationErrors result = new ValidationErrors(o);
            v.validate(o, (Errors)result);
            if (result.hasErrors()) {
                this.onErrors(o, (Errors)result);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            currentSession.setFlushMode(flushMode);
        }
    }

    protected void onErrors(Object object, Errors errors) {
        this.datastore.setObjectErrors(object, errors);
    }
}

