/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.rpc;

import com.android.tools.idea.editors.gfxtrace.rpc.AtomStream;
import com.android.tools.idea.editors.gfxtrace.rpc.AtomStreamId;
import com.android.tools.idea.editors.gfxtrace.rpc.Binary;
import com.android.tools.idea.editors.gfxtrace.rpc.BinaryId;
import com.android.tools.idea.editors.gfxtrace.rpc.Capture;
import com.android.tools.idea.editors.gfxtrace.rpc.CaptureId;
import com.android.tools.idea.editors.gfxtrace.rpc.Client;
import com.android.tools.idea.editors.gfxtrace.rpc.Commands;
import com.android.tools.idea.editors.gfxtrace.rpc.Device;
import com.android.tools.idea.editors.gfxtrace.rpc.DeviceId;
import com.android.tools.idea.editors.gfxtrace.rpc.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.rpc.HierarchyId;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.ImageInfoId;
import com.android.tools.idea.editors.gfxtrace.rpc.MemoryInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.MemoryInfoId;
import com.android.tools.idea.editors.gfxtrace.rpc.MemoryRange;
import com.android.tools.idea.editors.gfxtrace.rpc.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.rpc.Schema;
import com.android.tools.idea.editors.gfxtrace.rpc.SchemaId;
import com.android.tools.idea.editors.gfxtrace.rpc.TimingInfo;
import com.android.tools.idea.editors.gfxtrace.rpc.TimingInfoId;
import com.android.tools.idea.editors.gfxtrace.rpc.TimingMask;
import com.android.tools.rpclib.rpccore.Broadcaster;
import com.android.tools.rpclib.rpccore.Call;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ClientImpl
implements Client {
    private final Broadcaster myBroadcaster;
    private final ExecutorService myExecutorService;

    public ClientImpl(ExecutorService executorService, InputStream in, OutputStream out, int mtu) {
        this.myExecutorService = executorService;
        this.myBroadcaster = new Broadcaster(in, out, mtu, this.myExecutorService);
    }

    @Override
    public Future<CaptureId[]> GetCaptures() {
        return this.myExecutorService.submit(new GetCapturesCallable());
    }

    @Override
    public Future<DeviceId[]> GetDevices() {
        return this.myExecutorService.submit(new GetDevicesCallable());
    }

    @Override
    public Future<BinaryId> GetState(CaptureId capture, int contextId, long after) {
        return this.myExecutorService.submit(new GetStateCallable(capture, contextId, after));
    }

    @Override
    public Future<HierarchyId> GetHierarchy(CaptureId capture, int contextId) {
        return this.myExecutorService.submit(new GetHierarchyCallable(capture, contextId));
    }

    @Override
    public Future<MemoryInfoId> GetMemoryInfo(CaptureId capture, int contextId, long after, MemoryRange rng) {
        return this.myExecutorService.submit(new GetMemoryInfoCallable(capture, contextId, after, rng));
    }

    @Override
    public Future<ImageInfoId> GetFramebufferColor(DeviceId device, CaptureId capture, int contextId, long after, RenderSettings settings) {
        return this.myExecutorService.submit(new GetFramebufferColorCallable(device, capture, contextId, after, settings));
    }

    @Override
    public Future<ImageInfoId> GetFramebufferDepth(DeviceId device, CaptureId capture, int contextId, long after) {
        return this.myExecutorService.submit(new GetFramebufferDepthCallable(device, capture, contextId, after));
    }

    @Override
    public Future<CaptureId> ReplaceAtom(CaptureId capture, long atomId, short atomType, Binary data) {
        return this.myExecutorService.submit(new ReplaceAtomCallable(capture, atomId, atomType, data));
    }

    @Override
    public Future<TimingInfoId> GetTimingInfo(DeviceId device, CaptureId capture, int contextId, TimingMask mask) {
        return this.myExecutorService.submit(new GetTimingInfoCallable(device, capture, contextId, mask));
    }

    @Override
    public Future<BinaryId> PrerenderFramebuffers(DeviceId device, CaptureId capture, int width, int height, long[] atomIds) {
        return this.myExecutorService.submit(new PrerenderFramebuffersCallable(device, capture, width, height, atomIds));
    }

    @Override
    public Future<AtomStream> ResolveAtomStream(AtomStreamId id) {
        return this.myExecutorService.submit(new ResolveAtomStreamCallable(id));
    }

    @Override
    public Future<Binary> ResolveBinary(BinaryId id) {
        return this.myExecutorService.submit(new ResolveBinaryCallable(id));
    }

    @Override
    public Future<Capture> ResolveCapture(CaptureId id) {
        return this.myExecutorService.submit(new ResolveCaptureCallable(id));
    }

    @Override
    public Future<Device> ResolveDevice(DeviceId id) {
        return this.myExecutorService.submit(new ResolveDeviceCallable(id));
    }

    @Override
    public Future<Hierarchy> ResolveHierarchy(HierarchyId id) {
        return this.myExecutorService.submit(new ResolveHierarchyCallable(id));
    }

    @Override
    public Future<ImageInfo> ResolveImageInfo(ImageInfoId id) {
        return this.myExecutorService.submit(new ResolveImageInfoCallable(id));
    }

    @Override
    public Future<MemoryInfo> ResolveMemoryInfo(MemoryInfoId id) {
        return this.myExecutorService.submit(new ResolveMemoryInfoCallable(id));
    }

    @Override
    public Future<Schema> ResolveSchema(SchemaId id) {
        return this.myExecutorService.submit(new ResolveSchemaCallable(id));
    }

    @Override
    public Future<TimingInfo> ResolveTimingInfo(TimingInfoId id) {
        return this.myExecutorService.submit(new ResolveTimingInfoCallable(id));
    }

    private class ResolveTimingInfoCallable
    implements Callable<TimingInfo> {
        private final Commands.ResolveTimingInfo.Call myCall;

        private ResolveTimingInfoCallable(TimingInfoId id) {
            this.myCall = new Commands.ResolveTimingInfo.Call(id);
        }

        @Override
        public TimingInfo call() throws Exception {
            Commands.ResolveTimingInfo.Result result = (Commands.ResolveTimingInfo.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveSchemaCallable
    implements Callable<Schema> {
        private final Commands.ResolveSchema.Call myCall;

        private ResolveSchemaCallable(SchemaId id) {
            this.myCall = new Commands.ResolveSchema.Call(id);
        }

        @Override
        public Schema call() throws Exception {
            Commands.ResolveSchema.Result result = (Commands.ResolveSchema.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveMemoryInfoCallable
    implements Callable<MemoryInfo> {
        private final Commands.ResolveMemoryInfo.Call myCall;

        private ResolveMemoryInfoCallable(MemoryInfoId id) {
            this.myCall = new Commands.ResolveMemoryInfo.Call(id);
        }

        @Override
        public MemoryInfo call() throws Exception {
            Commands.ResolveMemoryInfo.Result result = (Commands.ResolveMemoryInfo.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveImageInfoCallable
    implements Callable<ImageInfo> {
        private final Commands.ResolveImageInfo.Call myCall;

        private ResolveImageInfoCallable(ImageInfoId id) {
            this.myCall = new Commands.ResolveImageInfo.Call(id);
        }

        @Override
        public ImageInfo call() throws Exception {
            Commands.ResolveImageInfo.Result result = (Commands.ResolveImageInfo.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveHierarchyCallable
    implements Callable<Hierarchy> {
        private final Commands.ResolveHierarchy.Call myCall;

        private ResolveHierarchyCallable(HierarchyId id) {
            this.myCall = new Commands.ResolveHierarchy.Call(id);
        }

        @Override
        public Hierarchy call() throws Exception {
            Commands.ResolveHierarchy.Result result = (Commands.ResolveHierarchy.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveDeviceCallable
    implements Callable<Device> {
        private final Commands.ResolveDevice.Call myCall;

        private ResolveDeviceCallable(DeviceId id) {
            this.myCall = new Commands.ResolveDevice.Call(id);
        }

        @Override
        public Device call() throws Exception {
            Commands.ResolveDevice.Result result = (Commands.ResolveDevice.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveCaptureCallable
    implements Callable<Capture> {
        private final Commands.ResolveCapture.Call myCall;

        private ResolveCaptureCallable(CaptureId id) {
            this.myCall = new Commands.ResolveCapture.Call(id);
        }

        @Override
        public Capture call() throws Exception {
            Commands.ResolveCapture.Result result = (Commands.ResolveCapture.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveBinaryCallable
    implements Callable<Binary> {
        private final Commands.ResolveBinary.Call myCall;

        private ResolveBinaryCallable(BinaryId id) {
            this.myCall = new Commands.ResolveBinary.Call(id);
        }

        @Override
        public Binary call() throws Exception {
            Commands.ResolveBinary.Result result = (Commands.ResolveBinary.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ResolveAtomStreamCallable
    implements Callable<AtomStream> {
        private final Commands.ResolveAtomStream.Call myCall;

        private ResolveAtomStreamCallable(AtomStreamId id) {
            this.myCall = new Commands.ResolveAtomStream.Call(id);
        }

        @Override
        public AtomStream call() throws Exception {
            Commands.ResolveAtomStream.Result result = (Commands.ResolveAtomStream.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class PrerenderFramebuffersCallable
    implements Callable<BinaryId> {
        private final Commands.PrerenderFramebuffers.Call myCall;

        private PrerenderFramebuffersCallable(DeviceId device, CaptureId capture, int width, int height, long[] atomIds) {
            this.myCall = new Commands.PrerenderFramebuffers.Call(device, capture, width, height, atomIds);
        }

        @Override
        public BinaryId call() throws Exception {
            Commands.PrerenderFramebuffers.Result result = (Commands.PrerenderFramebuffers.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetTimingInfoCallable
    implements Callable<TimingInfoId> {
        private final Commands.GetTimingInfo.Call myCall;

        private GetTimingInfoCallable(DeviceId device, CaptureId capture, int contextId, TimingMask mask) {
            this.myCall = new Commands.GetTimingInfo.Call(device, capture, contextId, mask);
        }

        @Override
        public TimingInfoId call() throws Exception {
            Commands.GetTimingInfo.Result result = (Commands.GetTimingInfo.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class ReplaceAtomCallable
    implements Callable<CaptureId> {
        private final Commands.ReplaceAtom.Call myCall;

        private ReplaceAtomCallable(CaptureId capture, long atomId, short atomType, Binary data) {
            this.myCall = new Commands.ReplaceAtom.Call(capture, atomId, atomType, data);
        }

        @Override
        public CaptureId call() throws Exception {
            Commands.ReplaceAtom.Result result = (Commands.ReplaceAtom.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetFramebufferDepthCallable
    implements Callable<ImageInfoId> {
        private final Commands.GetFramebufferDepth.Call myCall;

        private GetFramebufferDepthCallable(DeviceId device, CaptureId capture, int contextId, long after) {
            this.myCall = new Commands.GetFramebufferDepth.Call(device, capture, contextId, after);
        }

        @Override
        public ImageInfoId call() throws Exception {
            Commands.GetFramebufferDepth.Result result = (Commands.GetFramebufferDepth.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetFramebufferColorCallable
    implements Callable<ImageInfoId> {
        private final Commands.GetFramebufferColor.Call myCall;

        private GetFramebufferColorCallable(DeviceId device, CaptureId capture, int contextId, long after, RenderSettings settings) {
            this.myCall = new Commands.GetFramebufferColor.Call(device, capture, contextId, after, settings);
        }

        @Override
        public ImageInfoId call() throws Exception {
            Commands.GetFramebufferColor.Result result = (Commands.GetFramebufferColor.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetMemoryInfoCallable
    implements Callable<MemoryInfoId> {
        private final Commands.GetMemoryInfo.Call myCall;

        private GetMemoryInfoCallable(CaptureId capture, int contextId, long after, MemoryRange rng) {
            this.myCall = new Commands.GetMemoryInfo.Call(capture, contextId, after, rng);
        }

        @Override
        public MemoryInfoId call() throws Exception {
            Commands.GetMemoryInfo.Result result = (Commands.GetMemoryInfo.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetHierarchyCallable
    implements Callable<HierarchyId> {
        private final Commands.GetHierarchy.Call myCall;

        private GetHierarchyCallable(CaptureId capture, int contextId) {
            this.myCall = new Commands.GetHierarchy.Call(capture, contextId);
        }

        @Override
        public HierarchyId call() throws Exception {
            Commands.GetHierarchy.Result result = (Commands.GetHierarchy.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetStateCallable
    implements Callable<BinaryId> {
        private final Commands.GetState.Call myCall;

        private GetStateCallable(CaptureId capture, int contextId, long after) {
            this.myCall = new Commands.GetState.Call(capture, contextId, after);
        }

        @Override
        public BinaryId call() throws Exception {
            Commands.GetState.Result result = (Commands.GetState.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetDevicesCallable
    implements Callable<DeviceId[]> {
        private final Commands.GetDevices.Call myCall = new Commands.GetDevices.Call();

        private GetDevicesCallable() {
        }

        @Override
        public DeviceId[] call() throws Exception {
            Commands.GetDevices.Result result = (Commands.GetDevices.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }

    private class GetCapturesCallable
    implements Callable<CaptureId[]> {
        private final Commands.GetCaptures.Call myCall = new Commands.GetCaptures.Call();

        private GetCapturesCallable() {
        }

        @Override
        public CaptureId[] call() throws Exception {
            Commands.GetCaptures.Result result = (Commands.GetCaptures.Result)ClientImpl.this.myBroadcaster.Send((Call)this.myCall);
            return result.myValue;
        }
    }
}

