/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditor
extends UserDataHolderBase
implements FileEditor {
    private final ThemeEditorVirtualFile myVirtualFile;
    private final ThemeEditorComponent myComponent;

    public ThemeEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/theme/ThemeEditor", "<init>"));
        }
        this.myVirtualFile = (ThemeEditorVirtualFile)file;
        this.myComponent = new ThemeEditorComponent(project);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ThemeEditor.this.myComponent.reload(ThemeEditor.this.myComponent.getPreviousSelectedTheme());
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        ThemeEditorComponent themeEditorComponent = this.myComponent;
        if (themeEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditor", "getComponent"));
        }
        return themeEditorComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("Theme Editor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditor", "getName"));
        }
        return "Theme Editor";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel fileEditorStateLevel) {
        if (fileEditorStateLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorStateLevel", "com/android/tools/idea/editors/theme/ThemeEditor", "getState"));
        }
        ThemeEditorStyle theme = this.myComponent.getSelectedTheme();
        ThemeEditorStyle subStyle = this.myComponent.getCurrentSubStyle();
        ThemeEditorState themeEditorState = new ThemeEditorState(theme == null ? null : theme.getName(), subStyle == null ? null : subStyle.getName(), Float.valueOf(this.myComponent.getProportion()));
        if (themeEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditor", "getState"));
        }
        return themeEditorState;
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
        if (fileEditorState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorState", "com/android/tools/idea/editors/theme/ThemeEditor", "setState"));
        }
        if (!(fileEditorState instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState state = (ThemeEditorState)fileEditorState;
        this.myComponent.reload(state.getThemeName(), state.getSubStyleName());
        this.myComponent.setProportion(state.getProportion());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void selectNotify() {
        this.myComponent.reload(this.myComponent.getPreviousSelectedTheme());
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyChangeListener", "com/android/tools/idea/editors/theme/ThemeEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyChangeListener", "com/android/tools/idea/editors/theme/ThemeEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.myComponent.dispose();
    }

    @NotNull
    public ThemeEditorVirtualFile getVirtualFile() {
        ThemeEditorVirtualFile themeEditorVirtualFile = this.myVirtualFile;
        if (themeEditorVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditor", "getVirtualFile"));
        }
        return themeEditorVirtualFile;
    }
}

