/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ColorPalette;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;

public class AttributesModelColorPaletteModel
implements ColorPalette.ColorPaletteModel,
TableModelListener {
    private final ResourceResolver myResourceResolver;
    private final AttributesTableModel myModel;
    private List<Color> myColorList;
    private Multimap<Color, EditedStyleItem> myColorReferences;

    public AttributesModelColorPaletteModel(@NotNull Configuration configuration, @NotNull AttributesTableModel model) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel", "<init>"));
        }
        this.myColorReferences = HashMultimap.create();
        this.myResourceResolver = configuration.getResourceResolver();
        this.myModel = model;
        this.myModel.addTableModelListener(this);
        this.loadColors();
    }

    @Override
    public int getCount() {
        return this.myColorList.size();
    }

    @Override
    @NotNull
    public Color getColorAt(int i) {
        Color color = this.myColorList.get(i);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel", "getColorAt"));
        }
        return color;
    }

    @Override
    public int indexOf(@NotNull Color c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel", "indexOf"));
        }
        return this.myColorList.indexOf(c);
    }

    @Override
    @NotNull
    public String getToolTipAt(int i) {
        StringBuilder tooltip = new StringBuilder("This color is used in:\n\n");
        for (EditedStyleItem item : this.myColorReferences.get((Object)this.myColorList.get(i))) {
            tooltip.append(item.getName()).append('\n');
        }
        String string = tooltip.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesModelColorPaletteModel", "getToolTipAt"));
        }
        return string;
    }

    private void loadColors() {
        if (this.myResourceResolver == null) {
            this.myColorList = Collections.emptyList();
            return;
        }
        int rows = this.myModel.getRowCount();
        HashMultiset colorSet = HashMultiset.create();
        for (int i = 0; i < rows; ++i) {
            if (this.myModel.getCellClass(i, 0) != Color.class) continue;
            EditedStyleItem item = (EditedStyleItem)this.myModel.getValueAt(i, 0);
            for (Color color : ResourceHelper.resolveMultipleColors((RenderResources)this.myResourceResolver, (ResourceValue)item.getItemResourceValue())) {
                this.myColorReferences.put((Object)color, (Object)item);
                colorSet.add((Object)color);
            }
        }
        this.myColorList = ImmutableList.copyOf((Collection)Multisets.copyHighestCountFirst((Multiset)colorSet).elementSet());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.loadColors();
    }

    public List<EditedStyleItem> getReferences(Color color) {
        return ImmutableList.copyOf((Collection)this.myColorReferences.get((Object)color));
    }
}

