/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.ResourceComponent;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.util.GraphicsUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.geom.RoundRectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ColorComponent
extends ResourceComponent {
    @NotNull
    private List<Color> myColors = Collections.emptyList();
    private ColorIcon myIcon = new ColorIcon();

    @Override
    int getIconCount() {
        return this.myColors.size();
    }

    @Override
    Icon getIconAt(int i) {
        this.myIcon.setColor(this.myColors.get(i));
        return this.myIcon;
    }

    @Override
    void setIconHeight(int height) {
        this.myIcon.setHeight(height);
    }

    public void configure(@NotNull EditedStyleItem resValue, @NotNull List<Color> colors) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/editors/theme/attributes/editors/ColorComponent", "configure"));
        }
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/android/tools/idea/editors/theme/attributes/editors/ColorComponent", "configure"));
        }
        String colorText = colors.isEmpty() ? "(empty)" : ResourceHelper.colorToString(colors.get(0));
        this.configure(ThemeEditorUtils.getDisplayHtml(resValue), colorText, resValue.getValue());
        this.myColors = ImmutableList.copyOf(colors);
    }

    static class ColorIcon
    implements Icon {
        private static final int ARC_SIZE = 10;
        private static final double THRESHOLD_SQUARED_DISTANCE = 0.01;
        private final float[] myRgbaArray = new float[4];
        private Color myColor;
        private int myCellSize;

        ColorIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.myColor.getAlpha() != 255) {
                RoundRectangle2D.Double clip = new RoundRectangle2D.Double(x, y, this.myCellSize, this.myCellSize, 10.0, 10.0);
                GraphicsUtil.paintCheckeredBackground(g, clip);
            }
            g.setColor(this.myColor);
            g.fillRoundRect(x, y, this.myCellSize, this.myCellSize, 10, 10);
            this.myColor.getRGBComponents(this.myRgbaArray);
            if (Math.pow(1.0 - (double)this.myRgbaArray[0], 2.0) + Math.pow(1.0 - (double)this.myRgbaArray[1], 2.0) + Math.pow(1.0 - (double)this.myRgbaArray[2], 2.0) < 0.01) {
                g.setColor((Color)Gray._239);
                g.drawRoundRect(x, y, this.myCellSize, this.myCellSize - 1, 10, 10);
            }
        }

        public void setHeight(int height) {
            this.myCellSize = height;
        }

        public void setColor(@NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/attributes/editors/ColorComponent$ColorIcon", "setColor"));
            }
            this.myColor = color;
        }

        @Override
        public int getIconWidth() {
            return this.myCellSize;
        }

        @Override
        public int getIconHeight() {
            return this.myCellSize;
        }
    }
}

