/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;

public class EditedStyleItem {
    private static final Logger LOG = Logger.getInstance(EditedStyleItem.class);
    private static final String DEPRECATED = "deprecated";
    private final ThemeEditorStyle mySourceTheme;
    private ItemResourceValue myItemResourceValue;
    private String myQualifiedValue;
    private final String myAttrGroup;

    public EditedStyleItem(@NotNull ItemResourceValue itemResourceValue, @NotNull ThemeEditorStyle sourceTheme) {
        if (itemResourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemResourceValue", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "<init>"));
        }
        if (sourceTheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTheme", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "<init>"));
        }
        this.myItemResourceValue = itemResourceValue;
        this.mySourceTheme = sourceTheme;
        AttributeDefinition attrDef = StyleResolver.getAttributeDefinition(sourceTheme.getConfiguration(), itemResourceValue);
        String attrGroup = attrDef == null ? null : attrDef.getAttrGroup();
        this.myAttrGroup = attrGroup == null ? "Other non-theme attributes." : attrGroup;
        this.myQualifiedValue = StyleResolver.getQualifiedValue(this.myItemResourceValue);
    }

    public void setValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "setValue"));
        }
        this.myItemResourceValue = new ItemResourceValue(this.myItemResourceValue.getName(), this.myItemResourceValue.isFrameworkAttr(), value, false);
        this.myQualifiedValue = value;
    }

    @NotNull
    public String getAttrGroup() {
        String string = this.myAttrGroup;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getAttrGroup"));
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myQualifiedValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getValue"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myItemResourceValue.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getName"));
        }
        return string;
    }

    public boolean isFrameworkAttr() {
        return this.myItemResourceValue.isFrameworkAttr();
    }

    @NotNull
    public ThemeEditorStyle getSourceStyle() {
        ThemeEditorStyle themeEditorStyle = this.mySourceTheme;
        if (themeEditorStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getSourceStyle"));
        }
        return themeEditorStyle;
    }

    @NotNull
    public ItemResourceValue getItemResourceValue() {
        ItemResourceValue itemResourceValue = this.myItemResourceValue;
        if (itemResourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getItemResourceValue"));
        }
        return itemResourceValue;
    }

    public boolean isAttr() {
        ResourceUrl url = ResourceUrl.parse((String)this.myItemResourceValue.getRawXmlValue(), (boolean)this.myItemResourceValue.isFramework());
        return url != null && url.type == ResourceType.ATTR;
    }

    public String toString() {
        return String.format("[%1$s] %2$s = %3$s", this.mySourceTheme, this.getName(), this.getValue());
    }

    @NotNull
    public String getQualifiedName() {
        String string = (this.getItemResourceValue().isFrameworkAttr() ? "android:" : "") + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/EditedStyleItem", "getQualifiedName"));
        }
        return string;
    }

    public String getAttrPropertyName() {
        if (!this.isAttr()) {
            return "";
        }
        String propertyName = (String)Splitter.on((char)'/').limit(2).splitToList((CharSequence)this.getValue()).get(1);
        return (this.getValue().startsWith("?android:") ? "android:" : "") + propertyName;
    }

    public boolean isDeprecated() {
        AttributeDefinition def = StyleResolver.getAttributeDefinition(this.mySourceTheme.getConfiguration(), this.myItemResourceValue);
        String doc = def == null ? null : def.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)DEPRECATED);
    }

    public boolean isPublicAttribute() {
        if (!this.myItemResourceValue.isFrameworkAttr()) {
            return true;
        }
        Configuration configuration = this.mySourceTheme.getConfiguration();
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, configuration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.ATTR.getName(), this.getName());
    }
}

