/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.idea.editors.theme.preview.ToolbarComponentDefinition;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class ThemePreviewBuilder {
    public static final String BUILDER_URI = "http://schemas.android.com/tools/preview/builder";
    public static final String BUILDER_NS_NAME = "builder";
    public static final String BUILDER_ATTR_GROUP = "group";
    static final String THEME_PREVIEW_LAYOUT = "com.android.tools.idea.editors.theme.widgets.ThemePreviewLayout";
    private static final Map<String, String> NAMESPACE_TO_URI = ImmutableMap.of((Object)"android", (Object)"http://schemas.android.com/apk/res/android", (Object)"app", (Object)"http://schemas.android.com/apk/res-auto", (Object)"builder", (Object)"http://schemas.android.com/tools/preview/builder");
    private final ArrayList<Predicate<ComponentDefinition>> myComponentFilters = new ArrayList();
    public static final List<ComponentDefinition> AVAILABLE_BASE_COMPONENTS = ImmutableList.of((Object)new ToolbarComponentDefinition(false), (Object)new ComponentDefinition("Normal", ComponentGroup.RAISED_BUTTON, "Button"), (Object)new ComponentDefinition("Disabled", ComponentGroup.RAISED_BUTTON, "Button").set("enabled", "false"), (Object)new ComponentDefinition("Normal", ComponentGroup.FLAT_BUTTON, "Button").set(null, "style", "?android:attr/borderlessButtonStyle"), (Object)new ComponentDefinition("Disabled", ComponentGroup.FLAT_BUTTON, "Button").set(null, "style", "?android:attr/borderlessButtonStyle").set("enabled", "false"), (Object)new ComponentDefinition("Radio button", ComponentGroup.RADIO_BUTTON, "RadioButton").setText(""), (Object)new ComponentDefinition("Pressed Radio button", ComponentGroup.RADIO_BUTTON, "RadioButton").set("checked", "true").setText(""), (Object)new ComponentDefinition("Checkbox", ComponentGroup.CHECKBOX, "CheckBox").setText(""), (Object)new ComponentDefinition("Pressed Checkbox", ComponentGroup.CHECKBOX, "CheckBox").set("checked", "true").setText(""), (Object)new ComponentDefinition("Switch", ComponentGroup.SWITCH, "Switch").setApiLevel(14).setText(""), (Object)new ComponentDefinition("On Switch", ComponentGroup.SWITCH, "Switch").setApiLevel(14).set("checked", "true").setText(""), (Object)new ComponentDefinition("Large text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceLarge"), (Object[])new ComponentDefinition[]{new ComponentDefinition("Medium text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceMedium"), new ComponentDefinition("Small text", ComponentGroup.TEXT, "TextView").set("textAppearance", "?android:attr/textAppearanceSmall"), new ComponentDefinition("Status bar", ComponentGroup.STATUS_BAR, "com.android.layoutlib.bridge.bars.StatusBar").set("layout_width", "match_parent"), new ComponentDefinition("Navigation bar", ComponentGroup.NAVIGATION_BAR, "com.android.layoutlib.bridge.bars.NavigationBar").set("layout_height", "@android:dimen/navigation_bar_height").set("layout_width", "match_parent"), new ComponentDefinition("ProgressBar", ComponentGroup.INDETERMINATE_PROGRESSBAR, "ProgressBar").set("progress", "50").set("layout_width", "match_parent"), new ComponentDefinition("ProgressBar", ComponentGroup.HORIZONTAL_PROGRESSBAR, "ProgressBar").set("progress", "50").set("layout_width", "match_parent").set(null, "style", "?android:attr/progressBarStyleHorizontal"), new ComponentDefinition("SeekBar", ComponentGroup.SLIDERS, "SeekBar").set("progress", "50").set("layout_width", "match_parent")});
    private static final int GROUP_TITLE_FONT_SIZE = 11;
    private List<ComponentDefinition> myComponents = new ArrayList<ComponentDefinition>();
    private String myGroupHeaderColor = "@android:color/darker_gray";
    private String myBackgroundColor = "@android:color/darker_gray";
    private PrintStream myDebugPrintStream;

    @NotNull
    private static Element buildGridLayoutElement(@NotNull Document document, int maxColumns, int minColumnWidth, int maxColumnWidth, int itemHorizontalMargin, int itemVerticalMargin) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildGridLayoutElement"));
        }
        Element layout = document.createElement(THEME_PREVIEW_LAYOUT);
        ThemePreviewBuilder.setAttribute(layout, "layout_width", "wrap_content");
        ThemePreviewBuilder.setAttribute(layout, "layout_height", "wrap_content");
        layout.setAttribute("max_columns", Integer.toString(maxColumns));
        if (minColumnWidth >= 0) {
            layout.setAttribute("min_column_width", Integer.toString(minColumnWidth));
        }
        if (maxColumnWidth >= 0) {
            layout.setAttribute("max_column_width", Integer.toString(maxColumnWidth));
        }
        if (itemHorizontalMargin >= 0) {
            layout.setAttribute("item_horizontal_margin", Integer.toString(itemHorizontalMargin));
        }
        if (itemVerticalMargin >= 0) {
            layout.setAttribute("item_vertical_margin", Integer.toString(itemVerticalMargin));
        }
        Element element = layout;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildGridLayoutElement"));
        }
        return element;
    }

    @NotNull
    private static Element buildElementGroup(@NotNull Document document, @NotNull ComponentGroup group, @NotNull String groupColor, @NotNull List<ComponentDefinition> components, boolean supressErrors) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildElementGroup"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILDER_ATTR_GROUP, "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildElementGroup"));
        }
        if (groupColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupColor", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildElementGroup"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildElementGroup"));
        }
        Element componentGrouper = document.createElement("RelativeLayout");
        ThemePreviewBuilder.setAttribute(componentGrouper, "layout_width", "wrap_content");
        ThemePreviewBuilder.setAttribute(componentGrouper, "layout_height", "wrap_content");
        ThemePreviewBuilder.setAttribute(componentGrouper, "background", "?android:attr/colorBackground");
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingTop", ThemePreviewBuilder.toDp(5));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingRight", ThemePreviewBuilder.toDp(10));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingLeft", ThemePreviewBuilder.toDp(10));
        ThemePreviewBuilder.setAttribute(componentGrouper, "paddingBottom", ThemePreviewBuilder.toDp(10));
        componentGrouper.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        Element elementGroup = document.createElement("LinearLayout");
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_height", "wrap_content");
        ThemePreviewBuilder.setAttribute(elementGroup, "orientation", group.orientation);
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_centerInParent", "true");
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_marginStart", ThemePreviewBuilder.toDp(10));
        ThemePreviewBuilder.setAttribute(elementGroup, "layout_marginBottom", ThemePreviewBuilder.toDp(50));
        ThemePreviewBuilder.setAttribute(elementGroup, "gravity", "center");
        elementGroup.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        Element groupTitle = document.createElement("TextView");
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_height", "wrap_content");
        ThemePreviewBuilder.setAttribute(groupTitle, "textSize", ThemePreviewBuilder.toSp(11));
        ThemePreviewBuilder.setAttribute(groupTitle, "textColor", groupColor);
        ThemePreviewBuilder.setAttribute(groupTitle, "text", group.name);
        ThemePreviewBuilder.setAttribute(groupTitle, "layout_alignParentBottom", "true");
        groupTitle.setAttributeNS(BUILDER_URI, BUILDER_ATTR_GROUP, group.name());
        for (ComponentDefinition definition : components) {
            elementGroup.appendChild(definition.build(document));
        }
        componentGrouper.appendChild(elementGroup);
        componentGrouper.appendChild(groupTitle);
        Element element = componentGrouper;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "buildElementGroup"));
        }
        return element;
    }

    @NotNull
    private List<ComponentDefinition> getComponentsByGroup(final @NotNull ComponentGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILDER_ATTR_GROUP, "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "getComponentsByGroup"));
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(this.myComponents, (Predicate)new Predicate<ComponentDefinition>(){

            public boolean apply(ComponentDefinition input) {
                if (group != input.group) {
                    return false;
                }
                for (Predicate filter : ThemePreviewBuilder.this.myComponentFilters) {
                    if (filter.apply((Object)input)) continue;
                    return false;
                }
                return true;
            }
        }));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "getComponentsByGroup"));
        }
        return immutableList;
    }

    private static void printDebug(@NotNull PrintStream out, @NotNull Document document) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "printDebug"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "printDebug"));
        }
        try {
            DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
            LSSerializer serializer = impl.createLSSerializer();
            LSOutput lsOutput = impl.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            lsOutput.setByteStream(out);
            serializer.write(document, lsOutput);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(out);
        }
        catch (InstantiationException e) {
            e.printStackTrace(out);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(out);
        }
    }

    private static String toDp(int n) {
        return String.format("%ddp", n);
    }

    private static String toSp(int n) {
        return String.format("%dsp", n);
    }

    private static void setAttribute(Element element, String name, String value) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value);
    }

    private static void setAttributeIfAbsent(Element element, String name, String value) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) {
            ThemePreviewBuilder.setAttribute(element, name, value);
        }
    }

    @NotNull
    public ThemePreviewBuilder addComponentFilter(@NotNull Predicate<ComponentDefinition> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addComponentFilter"));
        }
        this.myComponentFilters.add(filter);
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addComponentFilter"));
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder addAllComponents(@NotNull List<ComponentDefinition> definitions) {
        if (definitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitions", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addAllComponents"));
        }
        this.myComponents.addAll(definitions);
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addAllComponents"));
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder addComponent(@NotNull ComponentDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addComponent"));
        }
        this.addAllComponents((List<ComponentDefinition>)ImmutableList.of((Object)definition));
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "addComponent"));
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder setGroupHeaderColor(@NotNull String color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setGroupHeaderColor"));
        }
        this.myGroupHeaderColor = color;
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setGroupHeaderColor"));
        }
        return themePreviewBuilder;
    }

    @NotNull
    public ThemePreviewBuilder setGroupHeaderColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setGroupHeaderColor"));
        }
        this.setGroupHeaderColor('#' + Integer.toHexString(color.getRGB()));
        ThemePreviewBuilder themePreviewBuilder = this;
        if (themePreviewBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setGroupHeaderColor"));
        }
        return themePreviewBuilder;
    }

    public ThemePreviewBuilder setBackgroundColor(@NotNull String color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setBackgroundColor"));
        }
        this.myBackgroundColor = color;
        return this;
    }

    public ThemePreviewBuilder setBackgroundColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setBackgroundColor"));
        }
        this.setBackgroundColor('#' + Integer.toHexString(color.getRGB()));
        return this;
    }

    public ThemePreviewBuilder setDebug(@NotNull PrintStream printStream) {
        if (printStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printStream", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "setDebug"));
        }
        this.myDebugPrintStream = printStream;
        return this;
    }

    @NotNull
    public Document build() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element backgroundLayout = document.createElement("LinearLayout");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "layout_width", "match_parent");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "layout_height", "match_parent");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "paddingTop", ThemePreviewBuilder.toDp(20));
        ThemePreviewBuilder.setAttribute(backgroundLayout, "paddingBottom", ThemePreviewBuilder.toDp(20));
        ThemePreviewBuilder.setAttribute(backgroundLayout, "orientation", "vertical");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "gravity", "center_horizontal");
        ThemePreviewBuilder.setAttribute(backgroundLayout, "background", this.myBackgroundColor);
        Element layout = ThemePreviewBuilder.buildGridLayoutElement(document, 3, 270, 270, 25, 15);
        backgroundLayout.appendChild(layout);
        document.appendChild(backgroundLayout);
        for (ComponentGroup group : ComponentGroup.values()) {
            List<ComponentDefinition> components = this.getComponentsByGroup(group);
            if (components.isEmpty()) continue;
            Element elementGroup = ThemePreviewBuilder.buildElementGroup(document, group, this.myGroupHeaderColor, components, group == ComponentGroup.CUSTOM);
            layout.appendChild(elementGroup);
        }
        if (this.myDebugPrintStream != null) {
            ThemePreviewBuilder.printDebug(this.myDebugPrintStream, document);
        }
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder", "build"));
        }
        return document2;
    }

    public static class SearchFilter
    implements Predicate<ComponentDefinition> {
        private final boolean myCaseSensitive;
        private final String mySearchTerm;

        public SearchFilter(@NotNull String searchTerm, boolean caseSensitive) {
            if (searchTerm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchTerm", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$SearchFilter", "<init>"));
            }
            this.myCaseSensitive = caseSensitive;
            this.mySearchTerm = caseSensitive ? searchTerm : searchTerm.toLowerCase();
        }

        public SearchFilter(@NotNull String searchTerm) {
            if (searchTerm == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchTerm", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$SearchFilter", "<init>"));
            }
            this(searchTerm, false);
        }

        public boolean apply(ComponentDefinition input) {
            if (Strings.isNullOrEmpty((String)this.mySearchTerm)) {
                return true;
            }
            StringBuilder searchString = new StringBuilder(input.name);
            if (input.aliases != null) {
                searchString.append(' ').append(Joiner.on((char)' ').join(input.aliases));
            }
            searchString.append(' ').append(input.description).append(' ').append(input.group.name);
            return this.myCaseSensitive ? searchString.toString().contains(this.mySearchTerm) : searchString.toString().toLowerCase().contains(this.mySearchTerm);
        }
    }

    public static class ApiLevelFilter
    implements Predicate<ComponentDefinition> {
        private final int myApiLevel;

        public ApiLevelFilter(int apiLevel) {
            this.myApiLevel = apiLevel;
        }

        public boolean apply(ComponentDefinition input) {
            return input.apiLevel <= this.myApiLevel;
        }
    }

    public static class ComponentDefinition {
        private static final AtomicInteger ourCounter = new AtomicInteger(0);
        final String name;
        final ComponentGroup group;
        private final int id;
        final String description;
        final HashMap<String, String> attributes = new HashMap();
        private final int weight;
        int apiLevel;
        List<String> aliases;

        public ComponentDefinition(String description, ComponentGroup group, String name, int weight) {
            this.id = ourCounter.incrementAndGet();
            this.description = description;
            this.name = name;
            this.group = group;
            this.weight = weight;
        }

        public ComponentDefinition(String description, ComponentGroup group, String name) {
            this(description, group, name, 0);
        }

        @NotNull
        public ComponentDefinition set(@Nullable String ns, @NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            String prefix = ns != null ? ns + ":" : "";
            this.attributes.put(prefix + key, value);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            return componentDefinition;
        }

        @NotNull
        public ComponentDefinition set(@NotNull String key, @NotNull String value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            this.set("android", key, value);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "set"));
            }
            return componentDefinition;
        }

        @NotNull
        public ComponentDefinition setApiLevel(int apiLevel) {
            this.apiLevel = apiLevel;
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "setApiLevel"));
            }
            return componentDefinition;
        }

        String getId() {
            return "@+id/widget" + this.id;
        }

        @NotNull
        public ComponentDefinition setText(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "setText"));
            }
            this.set("text", text);
            ComponentDefinition componentDefinition = this;
            if (componentDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "setText"));
            }
            return componentDefinition;
        }

        public ComponentDefinition addAlias(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "addAlias"));
            }
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(text);
            return this;
        }

        Element build(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentDefinition", "build"));
            }
            Element component = document.createElement(this.name);
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                List keyComponents = Splitter.on((String)":").limit(2).splitToList((CharSequence)entry.getKey());
                if (keyComponents.size() != 1) {
                    component.setAttributeNS((String)NAMESPACE_TO_URI.get(keyComponents.get(0)), (String)keyComponents.get(1), entry.getValue());
                    continue;
                }
                component.setAttribute(entry.getKey(), entry.getValue());
            }
            ThemePreviewBuilder.setAttributeIfAbsent(component, "id", this.getId());
            ThemePreviewBuilder.setAttributeIfAbsent(component, "text", this.description);
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_width", "wrap_content");
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_height", "wrap_content");
            if (this.weight != 0) {
                ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_weight", Integer.toString(this.weight));
            }
            ThemePreviewBuilder.setAttributeIfAbsent(component, "layout_gravity", "center");
            if (!(component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_margin") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginLeft") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginRight") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginTop") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginBottom") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginStart") || component.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginEnd"))) {
                ThemePreviewBuilder.setAttribute(component, "layout_marginStart", ThemePreviewBuilder.toDp(12));
                ThemePreviewBuilder.setAttribute(component, "layout_marginEnd", ThemePreviewBuilder.toDp(12));
            }
            component.setAttributeNS(ThemePreviewBuilder.BUILDER_URI, ThemePreviewBuilder.BUILDER_ATTR_GROUP, this.group.name());
            return component;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentDefinition that = (ComponentDefinition)o;
            return Objects.equal((Object)((Object)this.group), (Object)((Object)that.group)) && Objects.equal((Object)this.name, (Object)that.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name});
        }
    }

    public static enum ComponentGroup {
        TOOLBAR("App bar", "vertical"),
        RAISED_BUTTON("Raised button", "vertical"),
        FLAT_BUTTON("Flat button", "vertical"),
        FAB_BUTTON("Fab button", "horizontal"),
        HORIZONTAL_PROGRESSBAR("Horizontal Progressbar", "horizontal"),
        INDETERMINATE_PROGRESSBAR("Progressbar (indeterminate)", "horizontal"),
        SLIDERS("Seekbar", "horizontal"),
        RADIO_BUTTON("Radiobutton", "horizontal"),
        CHECKBOX("Checkbox", "horizontal"),
        SWITCH("Switch", "horizontal"),
        TEXT("TextView", "vertical"),
        NAVIGATION_BAR("Navigation bar", "horizontal"),
        STATUS_BAR("Status bar", "horizontal"),
        CUSTOM("Custom", "vertical");

        final String name;
        final String orientation;

        private ComponentGroup(String name, String orientation) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentGroup", "<init>"));
            }
            if (orientation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/editors/theme/preview/ThemePreviewBuilder$ComponentGroup", "<init>"));
            }
            this.name = name;
            this.orientation = orientation;
        }
    }
}

