/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.eclipse.EclipseProject;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.eclipse.ImportModule;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

class EclipseImportModule
extends ImportModule {
    private final EclipseProject myProject;
    private List<ImportModule> myDirectDependencies;
    private List<ImportModule> myAllDependencies;

    public EclipseImportModule(@NonNull GradleImport importer, @NonNull EclipseProject project) {
        super(importer);
        this.myProject = project;
        this.myProject.setModule(this);
    }

    @Override
    @Nullable
    protected File getLintXml() {
        File lintXml = new File(this.myProject.getDir(), "lint.xml");
        return lintXml.exists() ? lintXml : null;
    }

    @Override
    @NonNull
    protected File resolveFile(@NonNull File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myProject.getDir(), file.getPath());
    }

    @Override
    protected void initDependencies() {
        GradleCoordinate dependency;
        super.initDependencies();
        for (String reference : this.myProject.getInferredLibraries()) {
            if (reference.equals("appcompat-v7")) {
                dependency = this.getAppCompatDependency();
                if (dependency == null) continue;
                this.myDependencies.add(dependency);
                this.myImporter.getSummary().reportReplacedLib(reference, Collections.singletonList(dependency));
                continue;
            }
            if (reference.equals("support-v4")) {
                dependency = this.getSupportLibDependency();
                if (dependency == null) continue;
                this.myDependencies.add(dependency);
                this.myImporter.getSummary().reportReplacedLib(reference, Collections.singletonList(dependency));
                continue;
            }
            if (reference.equals("gridlayout-v7")) {
                dependency = this.getGridLayoutDependency();
                if (dependency == null) continue;
                this.myDependencies.add(dependency);
                this.myImporter.getSummary().reportReplacedLib(reference, Collections.singletonList(dependency));
                continue;
            }
            if (!reference.equals("mediarouter-v7") || (dependency = this.getMediaRouterDependency()) == null) continue;
            this.myDependencies.add(dependency);
            this.myImporter.getSummary().reportReplacedLib(reference, Collections.singletonList(dependency));
        }
        for (File jar : this.myProject.getJarPaths()) {
            if (this.myImporter.isReplaceJars() && (dependency = this.guessDependency(jar)) != null) {
                this.myDependencies.add(dependency);
                this.myImporter.getSummary().reportReplacedJar(jar, dependency);
                continue;
            }
            this.myJarDependencies.add(this.getJarOutputRelativePath(jar));
        }
        for (File jar : this.myProject.getTestJarPaths()) {
            if (this.myImporter.isReplaceJars() && (dependency = this.guessDependency(jar)) != null) {
                this.myTestDependencies.add(dependency);
                this.myImporter.getSummary().reportReplacedJar(jar, dependency);
                continue;
            }
            this.myTestJarDependencies.add(EclipseImportModule.getTestJarOutputRelativePath(jar));
        }
    }

    public void addDependencies(@NonNull List<GradleCoordinate> dependencies) {
        for (GradleCoordinate dependency : dependencies) {
            if (this.myDependencies.contains(dependency)) continue;
            this.myDependencies.addAll(dependencies);
        }
    }

    @Override
    protected boolean dependsOnLibrary(@NonNull String pkg) {
        if (!this.isAndroidProject()) {
            return false;
        }
        if (pkg.equals(this.myProject.getPackage())) {
            return true;
        }
        for (EclipseProject project : this.myProject.getAllLibraries()) {
            if (!project.isAndroidProject() || !pkg.equals(project.getPackage())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    protected List<ImportModule> getDirectDependencies() {
        if (this.myDirectDependencies == null) {
            this.myDirectDependencies = Lists.newArrayList();
            for (EclipseProject project : this.myProject.getDirectLibraries()) {
                EclipseImportModule module = project.getModule();
                if (module == null) continue;
                this.myDirectDependencies.add(module);
            }
        }
        return this.myDirectDependencies;
    }

    @Override
    @NonNull
    protected List<ImportModule> getAllDependencies() {
        if (this.myAllDependencies == null) {
            this.myAllDependencies = Lists.newArrayList();
            for (EclipseProject project : this.myProject.getAllLibraries()) {
                EclipseImportModule module = project.getModule();
                if (module == null) continue;
                this.myAllDependencies.add(module);
            }
        }
        return this.myAllDependencies;
    }

    @Override
    protected Charset getProjectEncoding(@NonNull File file) {
        return this.myProject.getProjectEncoding();
    }

    @Override
    protected Charset getFileEncoding(@NonNull File file) {
        return this.myProject.getFileEncoding(file);
    }

    @Override
    @NonNull
    public File getDir() {
        return this.myProject.getDir();
    }

    @Override
    protected boolean isAndroidProject() {
        return this.myProject.isAndroidProject();
    }

    @Override
    protected boolean isLibrary() {
        return this.myProject.isLibrary();
    }

    @Override
    @Nullable
    protected String getPackage() {
        return this.myProject.getPackage();
    }

    @Override
    @NonNull
    protected String getOriginalName() {
        return this.myProject.getName();
    }

    @Override
    public boolean isApp() {
        return this.myProject.isAndroidProject() && !this.myProject.isLibrary();
    }

    @Override
    public boolean isAndroidLibrary() {
        return this.myProject.isAndroidProject() && this.myProject.isLibrary();
    }

    @Override
    public boolean isJavaLibrary() {
        return !this.myProject.isAndroidProject();
    }

    @Override
    public boolean isNdkProject() {
        return this.myProject.isNdkProject();
    }

    @Override
    @Nullable
    protected File getManifestFile() {
        return this.myProject.getManifestFile();
    }

    @Override
    @Nullable
    protected File getResourceDir() {
        return this.myProject.getResourceDir();
    }

    @Override
    @Nullable
    protected File getAssetsDir() {
        return this.myProject.getAssetsDir();
    }

    @Override
    @NonNull
    protected List<File> getSourcePaths() {
        return this.myProject.getSourcePaths();
    }

    @Override
    @NonNull
    protected List<File> getJarPaths() {
        return this.myProject.getJarPaths();
    }

    @Override
    @NonNull
    protected List<File> getTestJarPaths() {
        return this.myProject.getTestJarPaths();
    }

    @Override
    @NonNull
    protected List<File> getNativeLibs() {
        return this.myProject.getNativeLibs();
    }

    @Override
    @Nullable
    protected File getNativeSources() {
        return this.myProject.getNativeSources();
    }

    @Override
    @Nullable
    protected String getNativeModuleName() {
        return this.myProject.getNativeModuleName();
    }

    @Override
    @NonNull
    protected List<File> getLocalProguardFiles() {
        return this.myProject.getLocalProguardFiles();
    }

    @Override
    @NonNull
    protected List<File> getSdkProguardFiles() {
        return this.myProject.getSdkProguardFiles();
    }

    @Override
    @NonNull
    protected File getCanonicalModuleDir() {
        return this.myProject.getCanonicalDir();
    }

    @Override
    @Nullable
    protected File getOutputDir() {
        return this.myProject.getOutputDir();
    }

    @Override
    @NonNull
    protected String getLanguageLevel() {
        return this.myProject.getLanguageLevel();
    }

    @Override
    @NonNull
    protected AndroidVersion getCompileSdkVersion() {
        return this.myProject.getCompileSdkVersion();
    }

    @Override
    @Nullable
    protected String getAddOn() {
        return this.myProject.getAddOn();
    }

    @Override
    @NonNull
    protected AndroidVersion getTargetSdkVersion() {
        return this.myProject.getTargetSdkVersion();
    }

    @Override
    @NonNull
    protected AndroidVersion getMinSdkVersion() {
        return this.myProject.getMinSdkVersion();
    }

    @Override
    protected boolean dependsOn(@NonNull ImportModule other) {
        return this.myProject.getAllLibraries().contains(((EclipseImportModule)other).myProject);
    }

    @NonNull
    public EclipseProject getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    protected File getInstrumentationDir() {
        return this.myProject.getInstrumentationDir();
    }
}

