/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.AndroidFacetModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.AndroidSdkModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.RunConfigModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectDataService
extends AbstractProjectDataService<IdeaAndroidProject, Void> {
    private static final Logger LOG = Logger.getInstance(AndroidProjectDataService.class);
    private final List<ModuleCustomizer<IdeaAndroidProject>> myCustomizers;

    public AndroidProjectDataService() {
        this((List<ModuleCustomizer<IdeaAndroidProject>>)ImmutableList.of((Object)new AndroidSdkModuleCustomizer(), (Object)new AndroidFacetModuleCustomizer(), (Object)new ContentRootModuleCustomizer(), (Object)new RunConfigModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer()));
    }

    @VisibleForTesting
    AndroidProjectDataService(@NotNull List<ModuleCustomizer<IdeaAndroidProject>> customizers) {
        if (customizers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customizers", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "<init>"));
        }
        this.myCustomizers = customizers;
    }

    @NotNull
    public Key<IdeaAndroidProject> getTargetDataKey() {
        Key<IdeaAndroidProject> key = AndroidProjectKeys.IDE_ANDROID_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaAndroidProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                this.doImport(toImport, project, modelsProvider);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up Android modules in project '%1$s'", project.getName()), e);
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.getClass().getCanonicalName();
                }
                GradleSyncState.getInstance(project).syncFailed(msg);
            }
        }
    }

    private void doImport(final Collection<DataNode<IdeaAndroidProject>> toImport, final Project project, final IdeModifiableModelsProvider modelsProvider) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Sdk jdk;
                LanguageLevel javaLangVersion = null;
                ProjectSyncMessages messages = ProjectSyncMessages.getInstance(project);
                boolean hasExtraGeneratedFolders = false;
                Map androidProjectsByModuleName = AndroidProjectDataService.indexByModuleName(toImport);
                Charset ideEncoding = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
                PreciseRevision oneDotTwoModelVersion = new PreciseRevision(1, 2, 0);
                String nonMatchingModelEncodingFound = null;
                String modelVersionWithLayoutRenderingIssue = null;
                ArrayList modulesUsingBuildTools23rc1 = Lists.newArrayList();
                for (Module module : modelsProvider.getModules()) {
                    File[] sourceFolders;
                    PreciseRevision modelVersion;
                    IdeaAndroidProject androidProject = (IdeaAndroidProject)androidProjectsByModuleName.get(module.getName());
                    AndroidProjectDataService.this.customizeModule(module, project, modelsProvider, androidProject);
                    if (androidProject == null) continue;
                    AndroidProject delegate = androidProject.getDelegate();
                    AndroidProjectDataService.checkBuildToolsCompatibility(module, delegate, modulesUsingBuildTools23rc1);
                    if (modelVersionWithLayoutRenderingIssue == null && GradleUtil.hasLayoutRenderingIssue(delegate)) {
                        modelVersionWithLayoutRenderingIssue = delegate.getModelVersion();
                    }
                    boolean isModelVersionOneDotTwoOrNewer = (modelVersion = PreciseRevision.parseRevision((String)delegate.getModelVersion())).compareTo((FullRevision)oneDotTwoModelVersion, FullRevision.PreviewComparison.IGNORE) >= 0;
                    Charset modelEncoding = null;
                    if (isModelVersionOneDotTwoOrNewer) {
                        try {
                            modelEncoding = Charset.forName(delegate.getJavaCompileOptions().getEncoding());
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            // empty catch block
                        }
                    }
                    if (nonMatchingModelEncodingFound == null && modelEncoding != null && ideEncoding.compareTo(modelEncoding) != 0) {
                        nonMatchingModelEncodingFound = modelEncoding.displayName();
                    }
                    if (javaLangVersion == null) {
                        javaLangVersion = androidProject.getJavaLanguageLevel();
                    }
                    if ((sourceFolders = androidProject.getExtraGeneratedSourceFolders()).length > 0) {
                        hasExtraGeneratedFolders = true;
                    }
                    for (File folder : sourceFolders) {
                        String[] text = new String[]{"Folder " + folder.getPath()};
                        messages.add(new Message("Source folders generated at incorrect location", Message.Type.WARNING, text), new NotificationHyperlink[0]);
                    }
                }
                if (!modulesUsingBuildTools23rc1.isEmpty()) {
                    AndroidProjectDataService.reportBuildTools23rc1Usage(modulesUsingBuildTools23rc1, project);
                }
                if (nonMatchingModelEncodingFound != null) {
                    AndroidProjectDataService.setIdeEncodingAndAddEncodingMismatchMessage(nonMatchingModelEncodingFound, project);
                }
                if (modelVersionWithLayoutRenderingIssue != null) {
                    AndroidProjectDataService.addLayoutRenderingIssueMessage(modelVersionWithLayoutRenderingIssue, project);
                }
                if (hasExtraGeneratedFolders) {
                    messages.add(new Message("Source folders generated at incorrect location", Message.Type.INFO, "3rd-party Gradle plug-ins may be the cause"), new NotificationHyperlink[0]);
                }
                if ((jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk()) == null || !AndroidStudioSpecificInitializer.isAndroidStudio() && !Jdks.isApplicableJdk(jdk, javaLangVersion)) {
                    jdk = Jdks.chooseOrCreateJavaSdk(javaLangVersion);
                }
                if (jdk == null) {
                    String title = String.format("Problems importing/refreshing Gradle project '%1$s':\n", project.getName());
                    LanguageLevel level = javaLangVersion != null ? javaLangVersion : LanguageLevel.JDK_1_6;
                    String msg = String.format("Unable to find a JDK %1$s installed.\n", level.getPresentableText());
                    msg = msg + "After configuring a suitable JDK in the \"Project Structure\" dialog, sync the Gradle project again.";
                    NotificationData notification = new NotificationData(title, msg, NotificationCategory.ERROR, NotificationSource.PROJECT_SYNC);
                    ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
                } else {
                    String homePath = jdk.getHomePath();
                    if (homePath != null) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
                        homePath = FileUtil.toSystemDependentName((String)homePath);
                        IdeSdks.setJdkPath(new File(homePath));
                        PostProjectBuildTasksExecutor.getInstance(project).updateJavaLangLevelAfterBuild();
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    private static void checkBuildToolsCompatibility(@NotNull Module module, @NotNull AndroidProject project, @NotNull List<String> moduleNames) {
        Object value;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "checkBuildToolsCompatibility"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "checkBuildToolsCompatibility"));
        }
        if (moduleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNames", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "checkBuildToolsCompatibility"));
        }
        if (AndroidProjectDataService.isOneDotThreeOrLater(project)) {
            return;
        }
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile != null && "23.0.0 rc1".equals(value = buildFile.getValue(BuildFileKey.BUILD_TOOLS_VERSION))) {
            moduleNames.add(module.getName());
        }
    }

    private static boolean isOneDotThreeOrLater(@NotNull AndroidProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "isOneDotThreeOrLater"));
        }
        String modelVersion = project.getModelVersion();
        return !modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
    }

    private static void reportBuildTools23rc1Usage(@NotNull List<String> moduleNames, @NotNull Project project) {
        if (moduleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNames", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "reportBuildTools23rc1Usage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "reportBuildTools23rc1Usage"));
        }
        if (!moduleNames.isEmpty()) {
            Collections.sort(moduleNames);
            StringBuilder msg = new StringBuilder();
            msg.append("Build Tools 23.0.0 rc1 is <b>deprecated</b>.<br>\n").append("Please update these modules to use Build Tools 23.0.0 rc2 instead:");
            for (String moduleName : moduleNames) {
                msg.append("<br>\n * ").append(moduleName);
            }
            msg.append("<br>\n<br>\nOtherwise the project won't build. ");
            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
            notification.showBalloon("Android Build Tools", msg.toString(), NotificationType.ERROR);
        }
    }

    private static void setIdeEncodingAndAddEncodingMismatchMessage(@NotNull String newEncoding, @NotNull Project project) {
        if (newEncoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEncoding", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "setIdeEncodingAndAddEncodingMismatchMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "setIdeEncodingAndAddEncodingMismatchMessage"));
        }
        EncodingProjectManager encodings = EncodingProjectManager.getInstance((Project)project);
        String[] text = new String[]{String.format("The project encoding (%1$s) has been reset to the encoding specified in the Gradle build files (%2$s).", encodings.getDefaultCharset().displayName(), newEncoding), "Mismatching encodings can lead to serious bugs."};
        encodings.setDefaultCharsetName(newEncoding);
        OpenUrlHyperlink openDocHyperlink = new OpenUrlHyperlink("http://tools.android.com/knownissues/encoding", "More Info...");
        ProjectSyncMessages.getInstance(project).add(new Message("Gradle Sync Issue", Message.Type.INFO, text), openDocHyperlink);
    }

    private static void addLayoutRenderingIssueMessage(String modelVersion, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "addLayoutRenderingIssueMessage"));
        }
        FixGradleModelVersionHyperlink quickFix = new FixGradleModelVersionHyperlink(false);
        OpenUrlHyperlink openDocHyperlink = new OpenUrlHyperlink("https://code.google.com/p/android/issues/detail?id=170841", "More Info...");
        String[] text = new String[]{String.format("Using an obsolete version of the Gradle plugin (%1$s); this can lead to layouts not rendering correctly.", modelVersion)};
        ProjectSyncMessages.getInstance(project).add(new Message("Gradle Sync Issue", Message.Type.WARNING, text), openDocHyperlink, quickFix);
    }

    @NotNull
    private static Map<String, IdeaAndroidProject> indexByModuleName(@NotNull Collection<DataNode<IdeaAndroidProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "indexByModuleName"));
        }
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAndroidProject> d : dataNodes) {
            IdeaAndroidProject androidProject = (IdeaAndroidProject)d.getData();
            index.put(androidProject.getModuleName(), androidProject);
        }
        HashMap hashMap = index;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    private void customizeModule(@NotNull Module module, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable IdeaAndroidProject ideaAndroidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "customizeModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/AndroidProjectDataService", "customizeModule"));
        }
        for (ModuleCustomizer<IdeaAndroidProject> customizer : this.myCustomizers) {
            customizer.customizeModule(project, module, modelsProvider, ideaAndroidProject);
        }
    }
}

