/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProxyUtil {
    private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(File.class, Boolean.class, String.class, Integer.class, Collection.class, Set.class, (Object[])new Class[]{List.class, Map.class});

    private ProxyUtil() {
    }

    static boolean isSupported(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/util/ProxyUtil", "isSupported"));
        }
        return clazz.isPrimitive() || SUPPORTED_TYPES.contains(clazz);
    }

    @Nullable
    public static <T> T reproxy(@NotNull Type type, @Nullable T object) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/util/ProxyUtil", "reproxy"));
        }
        if (object == null) {
            return null;
        }
        if (object instanceof InvocationErrorValue) {
            return object;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            if (genericType.getRawType() instanceof Class) {
                Class genericClass = (Class)genericType.getRawType();
                if (Collection.class.isAssignableFrom(genericClass)) {
                    AbstractCollection newCollection;
                    Collection collection = (Collection)object;
                    if (genericClass.isAssignableFrom(ArrayList.class)) {
                        newCollection = Lists.newArrayListWithCapacity((int)collection.size());
                    } else if (genericClass.isAssignableFrom(LinkedHashSet.class)) {
                        newCollection = Sets.newLinkedHashSet();
                    } else {
                        throw new IllegalStateException("Unsupported collection type: " + genericClass.getCanonicalName());
                    }
                    Type argument = genericType.getActualTypeArguments()[0];
                    for (Object item : collection) {
                        newCollection.add(ProxyUtil.reproxy(argument, item));
                    }
                    return (T)newCollection;
                }
                if (Map.class.isAssignableFrom(genericClass)) {
                    Map map = (Map)object;
                    LinkedHashMap newMap = Maps.newLinkedHashMap();
                    Type keyType = genericType.getActualTypeArguments()[0];
                    Type valueType = genericType.getActualTypeArguments()[1];
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(ProxyUtil.reproxy(keyType, entry.getKey()), ProxyUtil.reproxy(valueType, entry.getValue()));
                    }
                    return (T)newMap;
                }
                throw new IllegalStateException("Unsupported generic type: " + genericClass.getCanonicalName());
            }
            throw new IllegalStateException("Unsupported raw type.");
        }
        if (!Proxy.isProxyClass(object.getClass())) {
            return object;
        }
        if (Proxy.getInvocationHandler(object) instanceof WrapperInvocationHandler) {
            return object;
        }
        Class<?>[] interfaces = object.getClass().getInterfaces();
        if (interfaces.length != 1) {
            throw new IllegalStateException("Cannot 'reproxy' a class with multiple interfaces");
        }
        Class<?> clazz = interfaces[0];
        HashMap values = Maps.newHashMap();
        for (Method m : clazz.getMethods()) {
            try {
                Object value;
                if (!Modifier.isPublic(m.getModifiers())) continue;
                try {
                    value = m.invoke(object, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    value = new InvocationErrorValue(e.getCause());
                }
                values.put(m.toGenericString(), ProxyUtil.reproxy(m.getGenericReturnType(), value));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("A non public method shouldn't have been called.", e);
            }
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new WrapperInvocationHandler(values));
    }

    private static class InvocationErrorValue
    implements Serializable {
        public Throwable exception;

        private InvocationErrorValue(Throwable exception) {
            this.exception = exception;
        }
    }

    static class WrapperInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final Method TO_STRING = WrapperInvocationHandler.getObjectMethod("toString", new Class[0]);
        private static final Method HASHCODE = WrapperInvocationHandler.getObjectMethod("hashCode", new Class[0]);
        private static final Method EQUALS = WrapperInvocationHandler.getObjectMethod("equals", Object.class);
        final Map<String, Object> values;

        WrapperInvocationHandler(@NotNull Map<String, Object> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/gradle/util/ProxyUtil$WrapperInvocationHandler", "<init>"));
            }
            this.values = values;
        }

        @NotNull
        private static Method getObjectMethod(@NotNull String name, Class<?> ... types) {
            Method method;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/util/ProxyUtil$WrapperInvocationHandler", "getObjectMethod"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/android/tools/idea/gradle/util/ProxyUtil$WrapperInvocationHandler", "getObjectMethod"));
            }
            try {
                method = Object.class.getMethod(name, types);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Method should exist in Object", e);
            }
            if (method == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/ProxyUtil$WrapperInvocationHandler", "getObjectMethod"));
            }
            return method;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (method.equals(TO_STRING) || method.equals(HASHCODE)) {
                return method.invoke((Object)this, objects);
            }
            if (method.equals(EQUALS)) {
                return this.proxyEquals(objects[0]);
            }
            String key = method.toGenericString();
            if (!this.values.containsKey(key)) {
                throw new UnsupportedMethodException("Method " + key + " not found");
            }
            Object value = this.values.get(key);
            if (value instanceof InvocationErrorValue) {
                throw ((InvocationErrorValue)value).exception;
            }
            return value;
        }

        private boolean proxyEquals(Object other) {
            return other != null && Proxy.isProxyClass(other.getClass()) && Proxy.getInvocationHandler(other).equals(this);
        }
    }
}

