/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.AndroidPsiDirectoryNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiFileNode
extends PsiFileNode {
    private final IdeaSourceProvider mySourceProvider;

    public AndroidPsiFileNode(Project project, PsiFile file, ViewSettings settings, IdeaSourceProvider sourceProvider) {
        super(project, file, settings);
        this.mySourceProvider = sourceProvider;
    }

    protected void updateImpl(PresentationData data) {
        super.updateImpl(data);
        if (this.mySourceProvider != null && !"main".equals(this.mySourceProvider.getName())) {
            data.addText(data.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + this.mySourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String sourceProviderName = this.mySourceProvider == null ? "" : this.mySourceProvider.getName();
        return this.getQualifiedNameSortKey() + "-" + ("main".equals(sourceProviderName) ? "" : sourceProviderName);
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return AndroidPsiDirectoryNode.toTestString(((PsiFile)this.getValue()).getName(), this.mySourceProvider);
    }
}

