/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote;

import com.android.annotations.NonNull;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UpdatablePkgInfo
implements Comparable<UpdatablePkgInfo> {
    private LocalPkgInfo myLocalInfo;
    private RemotePkgInfo myRemoteInfo;
    private RemotePkgInfo myRemotePreviewInfo;
    private final Logger LOG = Logger.getInstance(this.getClass());

    public UpdatablePkgInfo(@NonNull LocalPkgInfo localInfo) {
        this.init(localInfo, null);
    }

    public UpdatablePkgInfo(@NonNull RemotePkgInfo remoteInfo) {
        this.init(null, remoteInfo);
    }

    public UpdatablePkgInfo(@NonNull LocalPkgInfo localInfo, @NonNull RemotePkgInfo remoteInfo) {
        this.init(localInfo, remoteInfo);
    }

    private void init(@Nullable LocalPkgInfo localPkg, @Nullable RemotePkgInfo remotePkg) {
        assert (localPkg != null || remotePkg != null);
        this.myLocalInfo = localPkg;
        if (remotePkg != null) {
            this.addRemote(remotePkg);
        }
    }

    public void addRemote(@NonNull RemotePkgInfo remote) {
        this.checkInstallId(remote);
        if (remote.getPkgDesc().isPreview()) {
            if (this.myRemotePreviewInfo == null || remote.getPkgDesc().isUpdateFor(this.myRemotePreviewInfo.getPkgDesc(), FullRevision.PreviewComparison.IGNORE)) {
                this.myRemotePreviewInfo = remote;
            }
        } else if (this.myRemoteInfo == null || remote.getPkgDesc().isUpdateFor(this.myRemoteInfo.getPkgDesc(), FullRevision.PreviewComparison.IGNORE)) {
            this.myRemoteInfo = remote;
        }
    }

    private void checkInstallId(RemotePkgInfo remote) {
        if (this.myLocalInfo == null) {
            return;
        }
        String localIid = this.myLocalInfo.getDesc().getInstallId();
        String remoteIid = remote.getPkgDesc().getInstallId();
        if (remoteIid.equals(localIid)) {
            return;
        }
        if (!this.myLocalInfo.getDesc().isPreview() && remote.getPkgDesc().isPreview() && remoteIid.equals(localIid + "-preview")) {
            return;
        }
        assert (false) : String.format("%s doesn't match %s", remoteIid, localIid);
    }

    @Nullable
    public LocalPkgInfo getLocalInfo() {
        return this.myLocalInfo;
    }

    public RemotePkgInfo getRemote(boolean includePreview) {
        if (includePreview && (!this.hasRemote(false) || this.hasPreview() && this.myRemotePreviewInfo.getPkgDesc().isUpdateFor(this.myRemoteInfo.getPkgDesc(), FullRevision.PreviewComparison.IGNORE))) {
            return this.myRemotePreviewInfo;
        }
        return this.myRemoteInfo;
    }

    public boolean hasPreview() {
        return this.myRemotePreviewInfo != null;
    }

    public boolean hasRemote(boolean includePreview) {
        return this.myRemoteInfo != null || includePreview && this.myRemotePreviewInfo != null;
    }

    public boolean hasLocal() {
        return this.myLocalInfo != null;
    }

    @Override
    public int compareTo(UpdatablePkgInfo o) {
        return this.getPkgDesc(true).compareTo((Object)o.getPkgDesc(true));
    }

    public IPkgDesc getPkgDesc(boolean includePreview) {
        if (this.hasLocal()) {
            return this.myLocalInfo.getDesc();
        }
        if (includePreview && this.hasPreview()) {
            return this.myRemotePreviewInfo.getPkgDesc();
        }
        if (this.hasRemote(false)) {
            return this.getRemote(false).getPkgDesc();
        }
        return null;
    }

    public boolean isUpdate(boolean includePreview) {
        RemotePkgInfo remote = this.getRemote(includePreview);
        return this.myLocalInfo != null && remote != null && remote.getPkgDesc().getPreciseRevision().compareTo((FullRevision)this.myLocalInfo.getDesc().getPreciseRevision()) > 0;
    }

    public List<RemotePkgInfo> getAllRemotes() {
        SmartList result = new SmartList();
        if (this.myRemoteInfo != null) {
            result.add(this.myRemoteInfo);
        }
        if (this.myRemotePreviewInfo != null) {
            result.add(this.myRemotePreviewInfo);
        }
        return result;
    }
}

