/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;

public class FmHasDependencyMethod
implements TemplateMethodModelEx {
    private final Map<String, Object> myParamMap;

    public FmHasDependencyMethod(Map<String, Object> paramMap) {
        this.myParamMap = paramMap;
    }

    public TemplateModel exec(List args) throws TemplateModelException {
        IdeaAndroidProject gradleProject;
        AndroidFacet facet;
        Module module;
        Project project;
        VirtualFile file;
        String modulePath;
        Object listObject;
        if (args.size() != 1) {
            throw new TemplateModelException("Wrong arguments");
        }
        String artifact = ((TemplateScalarModel)args.get(0)).getAsString();
        if (artifact.isEmpty()) {
            return TemplateBooleanModel.FALSE;
        }
        if (this.myParamMap.containsKey("dependencyList") && (listObject = this.myParamMap.get("dependencyList")) instanceof List) {
            List dependencyList = (List)listObject;
            for (String dependency : dependencyList) {
                if (!dependency.contains(artifact)) continue;
                return TemplateBooleanModel.TRUE;
            }
        }
        if ((modulePath = (String)this.myParamMap.get("projectOut")) != null && (file = LocalFileSystem.getInstance().findFileByIoFile(new File(modulePath.replace('/', File.separatorChar)))) != null && (project = ProjectLocator.getInstance().guessProjectForFile(file)) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null && (facet = AndroidFacet.getInstance(module)) != null && (gradleProject = facet.getIdeaAndroidProject()) != null) {
            return GradleUtil.dependsOn(gradleProject, artifact) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (artifact.contains("com.android.support:appcompat-v7") || artifact.contains("com.android.support:support-v4")) {
            Object buildApiObject = this.myParamMap.get("buildApi");
            Object minApiObject = this.myParamMap.get("minApiLevel");
            if (buildApiObject instanceof Integer && minApiObject instanceof Integer) {
                int buildApi = (Integer)buildApiObject;
                int minApi = (Integer)minApiObject;
                return minApi >= 8 && (buildApi >= 21 && minApi < 21 || minApi < 14) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
        }
        return TemplateBooleanModel.FALSE;
    }
}

