/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties;

import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.Observable;
import com.google.common.collect.Lists;
import com.intellij.util.containers.UnsafeWeakList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservable
implements Observable {
    private final List<InvalidationListener> myListeners = Lists.newArrayListWithCapacity((int)0);
    private final UnsafeWeakList<InvalidationListener> myWeakListeners = new UnsafeWeakList(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservable", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservable", "removeListener"));
        }
        this.myListeners.remove(listener);
        this.myWeakListeners.remove((Object)listener);
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/ui/properties/AbstractObservable", "addWeakListener"));
        }
        this.myWeakListeners.add((Object)listener);
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener : this.myListeners) {
            listener.onInvalidated(this);
        }
        for (InvalidationListener listener : this.myWeakListeners) {
            listener.onInvalidated(this);
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

