/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.config;

import com.android.tools.idea.welcome.config.InstallerData;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FirstRunWizardMode {
    NEW_INSTALL,
    INSTALL_HANDOFF,
    MISSING_SDK;


    public boolean hasValidSdkLocation() {
        return this.getInstallerData().hasValidSdkLocation();
    }

    public boolean hasValidJdkLocation() {
        return this.getInstallerData().hasValidJdkLocation();
    }

    @Nullable
    public String getInstallerTimestamp() {
        return this.getInstallerData().getTimestamp();
    }

    @Nullable
    public File getJavaDir() {
        return this.getInstallerData().getJavaDir();
    }

    @Nullable
    public File getSdkLocation() {
        return this.getInstallerData().getAndroidDest();
    }

    public boolean shouldCreateAvd() {
        return this.getInstallerData().shouldCreateAvd();
    }

    @Nullable
    public File getAndroidSrc() {
        return this.getInstallerData().getAndroidSrc();
    }

    @NotNull
    private synchronized InstallerData getInstallerData() {
        if (this == INSTALL_HANDOFF) {
            InstallerData installerData = InstallerData.get();
            if (installerData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/config/FirstRunWizardMode", "getInstallerData"));
            }
            return installerData;
        }
        InstallerData installerData = InstallerData.EMPTY;
        if (installerData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/config/FirstRunWizardMode", "getInstallerData"));
        }
        return installerData;
    }
}

