/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.actions.NewAndroidComponentAction;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.ASGallery;
import com.android.tools.idea.wizard.AddAndroidActivityPath;
import com.android.tools.idea.wizard.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.TemplateEntry;
import com.android.tools.idea.wizard.TemplateListProvider;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityGalleryStep
extends DynamicWizardStepWithDescription {
    public static final ScopedStateStore.Key<TemplateEntry[]> KEY_TEMPLATES = ScopedStateStore.createKey("template.list", ScopedStateStore.Scope.STEP, TemplateEntry[].class);
    private final FormFactorUtils.FormFactor myFormFactor;
    private final ScopedStateStore.Key<TemplateEntry> myCurrentSelectionKey;
    private final boolean myShowSkipEntry;
    private ASGallery<Optional<TemplateEntry>> myGallery;

    public ActivityGalleryStep(@NotNull FormFactorUtils.FormFactor formFactor, boolean showSkipEntry, @NotNull ScopedStateStore.Key<TemplateEntry> currentSelectionKey, @NotNull Disposable disposable) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/ActivityGalleryStep", "<init>"));
        }
        if (currentSelectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSelectionKey", "com/android/tools/idea/wizard/ActivityGalleryStep", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/ActivityGalleryStep", "<init>"));
        }
        super(disposable);
        this.myFormFactor = formFactor;
        this.myCurrentSelectionKey = currentSelectionKey;
        this.myShowSkipEntry = showSkipEntry;
        this.setBodyComponent(this.createGallery());
    }

    private static String format(ScopedStateStore state, String formatString, ScopedStateStore.Key<?> ... keys) {
        Object[] arguments = new Object[keys.length];
        int i = 0;
        for (ScopedStateStore.Key<?> key : keys) {
            arguments[i++] = state.get(key);
        }
        return String.format(formatString, arguments);
    }

    private JComponent createGallery() {
        this.myGallery = new ASGallery();
        Dimension thumbnailSize = WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE;
        this.myGallery.setThumbnailSize(thumbnailSize);
        this.myGallery.setMinimumSize(new Dimension(thumbnailSize.width * 2 + 1, thumbnailSize.height));
        this.myGallery.setLabelProvider(new Function<Optional<TemplateEntry>, String>(){

            public String apply(Optional<TemplateEntry> template) {
                if (template.isPresent()) {
                    return ((TemplateEntry)template.get()).getTitle();
                }
                return ActivityGalleryStep.this.getNoTemplateEntryName();
            }
        });
        this.myGallery.setImageProvider(new Function<Optional<TemplateEntry>, Image>(){

            public Image apply(Optional<TemplateEntry> input) {
                return input.isPresent() ? ((TemplateEntry)input.get()).getImage() : null;
            }
        });
        this.myGallery.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ActivityGalleryStep.this.saveState(ActivityGalleryStep.this.myGallery);
            }
        });
        this.myGallery.setName("Templates Gallery");
        AccessibleContext accessibleContext = this.myGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getStepTitle());
        }
        JPanel panel = new JPanel((LayoutManager)new JBCardLayout());
        panel.add("only card", (Component)new JBScrollPane(this.myGallery));
        return panel;
    }

    protected String getNoTemplateEntryName() {
        return "Add No Activity";
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        UiNotifyConnector.doWhenFirstShown(this.myGallery, (Runnable)new Runnable(){

            @Override
            public void run() {
                ActivityGalleryStep.this.myGallery.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    @Override
    public boolean validate() {
        TemplateEntry template = this.myState.get(this.myCurrentSelectionKey);
        PageStatus status = template == null ? (this.myShowSkipEntry ? PageStatus.OK : PageStatus.NOTHING_SELECTED) : (this.isIncompatibleMinSdk(template) ? PageStatus.INCOMPATIBLE_MAIN_SDK : (this.isIncompatibleBuildApi(template) ? PageStatus.INCOMPATIBLE_BUILD_API : PageStatus.OK));
        this.setErrorHtml(status.formatMessage(this.myState));
        return status.isPageValid();
    }

    private boolean isIncompatibleBuildApi(TemplateEntry template) {
        Integer buildSdk = this.myState.get(AddAndroidActivityPath.KEY_BUILD_SDK);
        return buildSdk != null && buildSdk < template.getMinBuildApi();
    }

    private boolean isIncompatibleMinSdk(@NotNull TemplateEntry template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/android/tools/idea/wizard/ActivityGalleryStep", "isIncompatibleMinSdk"));
        }
        AndroidVersion minSdk = this.myState.get(AddAndroidActivityPath.KEY_MIN_SDK);
        return minSdk != null && minSdk.getApiLevel() < template.getMinSdk();
    }

    @Override
    public void init() {
        super.init();
        String formFactorName = this.myFormFactor.id;
        TemplateListProvider templateListProvider = new TemplateListProvider(formFactorName, NewAndroidComponentAction.NEW_WIZARD_CATEGORIES, TemplateManager.EXCLUDED_TEMPLATES);
        TemplateEntry[] list = templateListProvider.deriveValue(this.myState, AddAndroidActivityPath.KEY_IS_LAUNCHER, null);
        this.myGallery.setModel(JBList.createDefaultListModel((Object[])this.wrapInOptionals(list)));
        this.myState.put(KEY_TEMPLATES, list);
        if (list.length > 0) {
            this.myState.put(this.myCurrentSelectionKey, list[0]);
        }
        this.register(this.myCurrentSelectionKey, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry, ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(TemplateEntry newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ActivityGalleryStep$5", "setValue"));
                }
                component.setSelectedElement((Optional<TemplateEntry>)Optional.fromNullable((Object)newValue));
            }

            @Override
            @Nullable
            public TemplateEntry getValue(@NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ActivityGalleryStep$5", "getValue"));
                }
                Optional<TemplateEntry> selection = component.getSelectedElement();
                if (selection != null && selection.isPresent()) {
                    return (TemplateEntry)selection.get();
                }
                return null;
            }
        });
        this.register(KEY_TEMPLATES, this.myGallery, new ScopedDataBinder.ComponentBinding<TemplateEntry[], ASGallery<Optional<TemplateEntry>>>(){

            @Override
            public void setValue(@Nullable TemplateEntry[] newValue, @NotNull ASGallery<Optional<TemplateEntry>> component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ActivityGalleryStep$6", "setValue"));
                }
                component.setModel(JBList.createDefaultListModel((Object[])ActivityGalleryStep.this.wrapInOptionals(newValue)));
            }
        });
        this.registerValueDeriver(KEY_TEMPLATES, templateListProvider);
    }

    private Optional[] wrapInOptionals(@Nullable TemplateEntry[] newValue) {
        int i;
        Optional[] model;
        if (newValue == null) {
            return new Optional[0];
        }
        if (this.myShowSkipEntry) {
            model = new Optional[newValue.length + 1];
            model[0] = Optional.absent();
            i = 1;
        } else {
            model = new Optional[newValue.length];
            i = 0;
        }
        for (TemplateEntry entry : newValue) {
            model[i++] = Optional.of((Object)entry);
        }
        return model;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGallery;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Activity Gallery" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ActivityGalleryStep", "getStepName"));
        }
        return "Activity Gallery";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        String string = "Add an activity to " + this.myFormFactor.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ActivityGalleryStep", "getStepTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    @Override
    @Nullable
    protected Icon getStepIcon() {
        return this.myFormFactor.getIcon();
    }

    private static enum PageStatus {
        OK,
        INCOMPATIBLE_BUILD_API,
        INCOMPATIBLE_MAIN_SDK,
        NOTHING_SELECTED;


        public boolean isPageValid() {
            return this == OK;
        }

        @Nullable
        public String formatMessage(ScopedStateStore state) {
            switch (this) {
                case OK: {
                    return null;
                }
                case INCOMPATIBLE_BUILD_API: {
                    return ActivityGalleryStep.format(state, "Selected activity template has a minimum build API level of %d.", new ScopedStateStore.Key[]{AddAndroidActivityPath.KEY_BUILD_SDK});
                }
                case INCOMPATIBLE_MAIN_SDK: {
                    return ActivityGalleryStep.format(state, "Selected activity template has a minimum SDK level of %s.", new ScopedStateStore.Key[]{AddAndroidActivityPath.KEY_MIN_SDK});
                }
                case NOTHING_SELECTED: {
                    return "No activity template was selected.";
                }
            }
            throw new IllegalArgumentException(this.name());
        }
    }
}

