/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.ASGallery;
import com.android.tools.idea.wizard.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.ModuleTemplateProvider;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseModuleTypeStep
extends DynamicWizardStepWithDescription {
    private final Iterable<ModuleTemplateProvider> myModuleTypesProviders;
    private JPanel myPanel;
    private ASGallery<ModuleTemplate> myFormFactorGallery;

    public ChooseModuleTypeStep(Iterable<ModuleTemplateProvider> moduleTypesProviders, @Nullable Disposable parentDisposable) {
        super(parentDisposable);
        this.myModuleTypesProviders = moduleTypesProviders;
        this.$$$setupUI$$$();
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(UIUtil.getBorderColor()));
        this.setBodyComponent(this.myPanel);
    }

    @Override
    public void init() {
        super.init();
        ImmutableList.Builder deviceTemplates = ImmutableList.builder();
        ImmutableList.Builder extrasTemplates = ImmutableList.builder();
        HashSet formFactorSet = Sets.newHashSet();
        for (ModuleTemplateProvider provider : this.myModuleTypesProviders) {
            for (ModuleTemplate moduleTemplate : provider.getModuleTemplates()) {
                FormFactorUtils.FormFactor formFactor;
                boolean isAndroidDeviceTemplate;
                boolean bl = isAndroidDeviceTemplate = moduleTemplate.getFormFactor() != null;
                if (isAndroidDeviceTemplate) {
                    deviceTemplates.add((Object)moduleTemplate);
                } else {
                    extrasTemplates.add((Object)moduleTemplate);
                }
                if ((formFactor = moduleTemplate.getFormFactor()) == null) continue;
                formFactorSet.add(formFactor);
            }
        }
        for (final FormFactorUtils.FormFactor formFactor : formFactorSet) {
            this.registerValueDeriver(FormFactorUtils.getInclusionKey(formFactor), new ScopedDataBinder.ValueDeriver<Boolean>(){

                @Override
                @Nullable
                public Boolean deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable Boolean currentValue) {
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/wizard/ChooseModuleTypeStep$1", "deriveValue"));
                    }
                    ModuleTemplate moduleTemplate = ChooseModuleTypeStep.this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
                    return moduleTemplate != null && Objects.equal((Object)formFactor, (Object)moduleTemplate.getFormFactor());
                }
            });
        }
        ImmutableList galleryTemplatesList = deviceTemplates.build();
        ImmutableList extrasTemplatesList = extrasTemplates.build();
        Iterable allTemplates = Iterables.concat((Iterable)galleryTemplatesList, (Iterable)extrasTemplatesList);
        this.myFormFactorGallery.setModel(JBList.createDefaultListModel((Object[])Iterables.toArray((Iterable)allTemplates, ModuleTemplate.class)));
        ModuleTypeBinding binding = new ModuleTypeBinding();
        this.register(WizardConstants.SELECTED_MODULE_TYPE_KEY, this.myPanel, binding);
        this.myFormFactorGallery.addListSelectionListener(new ModuleTypeSelectionListener());
        if (!galleryTemplatesList.isEmpty()) {
            this.myState.put(WizardConstants.SELECTED_MODULE_TYPE_KEY, galleryTemplatesList.get(0));
        }
    }

    @Override
    public boolean commitStep() {
        ModuleTemplate selected = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        if (selected != null) {
            selected.updateWizardState(this.myState);
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Choose Module Type Step" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseModuleTypeStep", "getStepName"));
        }
        return "Choose Module Type Step";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("New Module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ChooseModuleTypeStep", "getStepTitle"));
        }
        return "New Module";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return "Android Studio";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFormFactorGallery;
    }

    private void createUIComponents() {
        this.myFormFactorGallery = new ASGallery<ModuleTemplate>(JBList.createDefaultListModel((Object[])new Object[0]), new Function<ModuleTemplate, Image>(){

            public Image apply(ModuleTemplate input) {
                return IconUtil.toImage((Icon)input.getIcon());
            }
        }, new Function<ModuleTemplate, String>(){

            public String apply(@Nullable ModuleTemplate input) {
                return input == null ? "<none>" : input.getName();
            }
        }, WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ASGallery<ModuleTemplate> aSGallery = this.myFormFactorGallery;
        jPanel.add(aSGallery, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ModuleTypeSelectionListener
    implements ListSelectionListener {
        private ModuleTypeSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ModuleTemplate moduleTemplate = (ModuleTemplate)ChooseModuleTypeStep.this.myFormFactorGallery.getSelectedElement();
            if (moduleTemplate != null) {
                ChooseModuleTypeStep.this.myState.put(DynamicWizardStepWithDescription.KEY_DESCRIPTION, moduleTemplate.getDescription());
            }
            ChooseModuleTypeStep.this.saveState(ChooseModuleTypeStep.this.myPanel);
            ChooseModuleTypeStep.this.invokeUpdate(WizardConstants.SELECTED_MODULE_TYPE_KEY);
        }
    }

    private class ModuleTypeBinding
    extends ScopedDataBinder.ComponentBinding<ModuleTemplate, JPanel> {
        private ModuleTypeBinding() {
        }

        @Override
        public void setValue(@Nullable ModuleTemplate newValue, @NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ChooseModuleTypeStep$ModuleTypeBinding", "setValue"));
            }
            ChooseModuleTypeStep.this.myFormFactorGallery.setSelectedElement(newValue);
        }

        @Override
        @Nullable
        public ModuleTemplate getValue(@NotNull JPanel component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/ChooseModuleTypeStep$ModuleTypeBinding", "getValue"));
            }
            return (ModuleTemplate)ChooseModuleTypeStep.this.myFormFactorGallery.getSelectedElement();
        }
    }
}

