/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.FileTreeModel;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import javax.swing.JTree;

public class FileTreeCellRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(JTree tree, Object nodeValue, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (nodeValue == null) {
            return;
        }
        FileTreeModel.Node node = (FileTreeModel.Node)nodeValue;
        if (node.existsOnDisk) {
            if (node.isConflicted) {
                this.append(node.name, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.append(node.name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else {
            this.append(node.name, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }
        if (node.children.isEmpty()) {
            if (node.icon != null) {
                this.setIcon(node.icon);
            } else {
                this.setIcon(AllIcons.FileTypes.Any_type);
            }
        } else {
            this.setIcon(PlatformIcons.FOLDER_ICON);
        }
    }
}

