/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.AddAndroidActivityPath;
import com.android.tools.idea.wizard.CreateModuleTemplate;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.NewModuleDynamicPath;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.TemplateEntry;
import com.android.tools.idea.wizard.TemplateParameterStep2;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.WizardUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import icons.AndroidIcons;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaModuleDynamicPath
extends DynamicWizardPath
implements NewModuleDynamicPath {
    public static final String JAVA_LIBRARY = "Java Library";
    private static final ScopedStateStore.Key<String> SRC_DIR = ScopedStateStore.createKey("srcDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> PACKAGE_NAME = ScopedStateStore.createKey("packageName", ScopedStateStore.Scope.PATH, String.class);
    @NotNull
    private final Disposable myDisposable;
    private final TemplateMetadata myMetadata;
    private final Template myTemplate;
    private CreateModuleTemplate myModuleTemplate;

    public JavaModuleDynamicPath(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/wizard/JavaModuleDynamicPath", "<init>"));
        }
        this.myDisposable = disposable;
        TemplateManager instance = TemplateManager.getInstance();
        this.myMetadata = instance.getTemplate("Application", JAVA_LIBRARY);
        assert (this.myMetadata != null);
        File templateFile = instance.getTemplateFile("Application", JAVA_LIBRARY);
        assert (templateFile != null);
        this.myTemplate = Template.createFromPath(templateFile);
        this.myModuleTemplate = new CreateModuleTemplate(this.myMetadata, null, this.myMetadata.getTitle(), AndroidIcons.ModuleTemplates.Android);
    }

    @Override
    protected void init() {
        TemplateParameterStep2 parameterStep = new TemplateParameterStep2(FormFactorUtils.FormFactor.MOBILE, (Map)ImmutableMap.of(), this.myDisposable, PACKAGE_NAME, new SourceProvider[0]){

            @Override
            public boolean isStepVisible() {
                return true;
            }
        };
        this.addStep(parameterStep);
        this.myState.put(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE, new TemplateEntry(this.myTemplate.getRootPath(), this.myMetadata));
        this.myState.put(SRC_DIR, "src/main/java");
        this.put("resDir", "src/main/res");
        this.put("aidlDir", "src/main/aidl");
        this.put("manifestDir", "src/main");
        this.put("testDir", "src/androidTest");
    }

    private void put(String attr, String value) {
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(attr, ScopedStateStore.Scope.PATH, String.class);
        this.myState.put(key, value);
    }

    @Override
    public boolean isPathVisible() {
        return this.myModuleTemplate.equals(this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY));
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("New Java Module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/JavaModuleDynamicPath", "getPathName"));
        }
        return "New Java Module";
    }

    @Override
    public boolean performFinishingActions() {
        Project project = this.getProject();
        assert (project != null);
        HashMap parameterValueMap = Maps.newHashMap();
        parameterValueMap.putAll(this.myState.flatten());
        String projectName = (String)parameterValueMap.get("projectName");
        String moduleName = WizardUtils.computeModuleName(projectName, this.getProject());
        String modulePath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{project.getBasePath(), moduleName}));
        parameterValueMap.put("projectOut", modulePath);
        parameterValueMap.put("projectName", moduleName);
        String packageName = this.myState.get(PACKAGE_NAME);
        assert (packageName != null);
        String packagePath = FileUtil.join((String[])new String[]{this.myState.getNotNull(SRC_DIR, "src/main/java/"), packageName.replace('.', '/')});
        String srcOut = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{modulePath, packagePath}));
        parameterValueMap.put("srcOut", srcOut);
        parameterValueMap.put("isNewProject", true);
        parameterValueMap.put("isLibraryProject", true);
        this.myTemplate.render(Projects.getBaseDirPath(project), new File(FileUtil.toSystemDependentName((String)modulePath)), parameterValueMap, project, false);
        return true;
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)this.myModuleTemplate);
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/JavaModuleDynamicPath", "getModuleTemplates"));
        }
        return immutableSet;
    }
}

