/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.AndroidModuleTemplatesProvider;
import com.android.tools.idea.wizard.ChooseModuleTypeStep;
import com.android.tools.idea.wizard.ConfigureAndroidProjectPath;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.NewFormFactorModulePath;
import com.android.tools.idea.wizard.NewModuleDynamicPath;
import com.android.tools.idea.wizard.NewModuleDynamicPathFactory;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.SingleStepPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewModuleWizardDynamic
extends DynamicWizard {
    public NewModuleWizardDynamic(@Nullable Project project, @Nullable Module module) {
        super(project, module, "New Module");
        this.setTitle("Create New Module");
    }

    @Override
    public void init() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable() || !TemplateManager.templatesAreValid()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing, out of date, or is missing templates.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return;
        }
        this.addPaths();
        ConfigureAndroidProjectPath.putSdkDependentParams(this.getState());
        this.initState();
        super.init();
    }

    protected void initState() {
        Project project;
        String mavenUrl;
        ScopedStateStore state = this.getState();
        state.put(WizardConstants.GRADLE_VERSION_KEY, "2.4");
        state.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, "1.2.3");
        state.put(WizardConstants.USE_PER_MODULE_REPOS_KEY, false);
        state.put(WizardConstants.IS_NEW_PROJECT_KEY, true);
        state.put(WizardConstants.IS_GRADLE_PROJECT_KEY, true);
        try {
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            this.LOG.error("Could not create default debug keystore: " + e.getMessage());
            state.put(WizardConstants.DEBUG_KEYSTORE_SHA_1_KEY, "");
        }
        AndroidSdkData sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (sdkData != null) {
            state.put(WizardConstants.SDK_DIR_KEY, sdkData.getLocation().getPath());
        }
        if ((mavenUrl = System.getProperty("android.mavenRepoUrl")) != null) {
            state.put(WizardConstants.MAVEN_URL_KEY, mavenUrl);
        }
        if ((project = this.getProject()) != null) {
            state.put(WizardConstants.PROJECT_LOCATION_KEY, project.getBasePath());
        }
        state.put(WizardConstants.FILES_TO_OPEN_KEY, Lists.newArrayList());
    }

    @NotNull
    protected static DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings buildHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader("New Module");
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewModuleWizardDynamic", "buildHeader"));
        }
        return wizardStepHeaderSettings;
    }

    protected void addPaths() {
        Collection<NewModuleDynamicPath> contributions = this.getContributedPaths();
        Iterable templateProviders = Iterables.concat((Iterable)ImmutableSet.of((Object)new AndroidModuleTemplatesProvider()), contributions);
        this.addPath(new SingleStepPath(new ChooseModuleTypeStep(templateProviders, this.getDisposable())));
        for (NewFormFactorModulePath path : NewFormFactorModulePath.getAvailableFormFactorModulePaths(this.getDisposable())) {
            path.setGradleSyncIfNecessary(false);
            this.addPath(path);
        }
        for (NewModuleDynamicPath contribution : contributions) {
            this.addPath(contribution);
        }
    }

    private Collection<NewModuleDynamicPath> getContributedPaths() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NewModuleDynamicPathFactory factory : (NewModuleDynamicPathFactory[])NewModuleDynamicPathFactory.EP_NAME.getExtensions()) {
            builder.addAll(factory.createWizardPaths(this.getProject(), this.getDisposable()));
        }
        return builder.build();
    }

    @Override
    protected String getWizardActionDescription() {
        String applicationName = this.getState().get(WizardConstants.APPLICATION_NAME_KEY);
        if (StringUtil.isEmptyOrSpaces((String)applicationName)) {
            ModuleTemplate moduleType = this.myState.get(WizardConstants.SELECTED_MODULE_TYPE_KEY);
            applicationName = moduleType != null ? moduleType.getName() : "Module";
        }
        return String.format("Create %1$s", applicationName);
    }

    @Override
    public void performFinishingActions() {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        GradleProjectImporter.getInstance().requestProjectSync(project, new NewProjectImportGradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/wizard/NewModuleWizardDynamic$1", "syncSucceeded"));
                }
                this.openTemplateFiles(project);
            }

            private boolean openTemplateFiles(Project project) {
                List<File> filesToOpen = NewModuleWizardDynamic.this.myState.get(WizardConstants.FILES_TO_OPEN_KEY);
                assert (filesToOpen != null);
                return TemplateUtils.openEditors(project, filesToOpen, true);
            }
        });
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Creating module..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/NewModuleWizardDynamic", "getProgressTitle"));
        }
        return "Creating module...";
    }
}

