/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.Log;
import com.google.common.primitives.Ints;
import com.intellij.openapi.util.Pair;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.logcat.AndroidLogcatReceiver;
import org.jetbrains.annotations.NonNls;

public class AndroidLogcatFormatter {
    static final String TAG_SEPARATOR = "\ufe55";
    @NonNls
    private static final Pattern LOGMESSAGE_PATTERN = Pattern.compile("(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/(.*)\ufe55 (.*)");

    public static String formatMessage(String message, AndroidLogcatReceiver.LogMessageHeader header) {
        String ids = String.format(Locale.US, "%d-%s", header.myPid, header.myTid);
        return String.format(Locale.US, "%1$s %2$12s/%3$s %4$c/%5$s%6$s %7$s", header.myTime, ids, header.myAppPackage.isEmpty() ? "?" : header.myAppPackage, Character.valueOf(header.myLogLevel.getPriorityLetter()), header.myTag, TAG_SEPARATOR, message);
    }

    public static Pair<AndroidLogcatReceiver.LogMessageHeader, String> parseMessage(String msg) {
        Matcher matcher = LOGMESSAGE_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return Pair.create(null, (Object)msg);
        }
        AndroidLogcatReceiver.LogMessageHeader header = new AndroidLogcatReceiver.LogMessageHeader();
        header.myTime = matcher.group(1).trim();
        Integer pid = Ints.tryParse((String)matcher.group(2));
        header.myPid = pid == null ? 0 : pid;
        header.myTid = matcher.group(3).trim();
        header.myAppPackage = matcher.group(4).trim();
        header.myLogLevel = Log.LogLevel.getByLetter((char)matcher.group(5).trim().charAt(0));
        header.myTag = matcher.group(6).trim();
        String message = matcher.group(7);
        return Pair.create((Object)header, (Object)message);
    }
}

