/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.run.AndroidRunConfiguration;
import org.jetbrains.android.run.AndroidRunConfigurationType;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.run.testing.AndroidTestRunConfigurationType;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Nullable;

public class AndroidConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidRunConfiguration> {
    public AndroidConfigurationProducer() {
        super((ConfigurationType)AndroidRunConfigurationType.getInstance());
    }

    @Nullable
    private static PsiClass getActivityClass(Location location, ConfigurationContext context) {
        GlobalSearchScope scope;
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiClass activityClass = facade.findClass("android.app.Activity", scope = module.getModuleWithDependenciesAndLibrariesScope(true));
        if (activityClass == null) {
            return null;
        }
        PsiClass elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        while (elementClass != null) {
            if (elementClass.isInheritor(activityClass, true)) {
                return elementClass;
            }
            elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementClass, PsiClass.class);
        }
        return null;
    }

    protected boolean setupConfigurationFromContext(AndroidRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(location, context);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        sourceElement.set((Object)activity);
        configuration.ACTIVITY_CLASS = activityName;
        configuration.MODE = "specific_activity";
        configuration.setName(JavaExecutionUtil.getPresentableClassName((String)configuration.ACTIVITY_CLASS));
        this.setupConfigurationModule(context, configuration);
        TargetSelectionMode targetSelectionMode = AndroidUtils.getDefaultTargetSelectionMode(context.getModule(), AndroidRunConfigurationType.getInstance(), AndroidTestRunConfigurationType.getInstance());
        if (targetSelectionMode != null) {
            configuration.setTargetSelectionMode(targetSelectionMode);
        }
        return true;
    }

    public boolean isConfigurationFromContext(AndroidRunConfiguration configuration, ConfigurationContext context) {
        Module confModule;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiClass activity = AndroidConfigurationProducer.getActivityClass(location, context);
        if (activity == null) {
            return false;
        }
        String activityName = activity.getQualifiedName();
        if (activityName == null) {
            return false;
        }
        Module contextModule = AndroidUtils.getAndroidModule(context);
        return Comparing.equal((Object)contextModule, (Object)(confModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule())) && activityName.equals(configuration.ACTIVITY_CLASS);
    }
}

